/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.eventListeners;

import com.bcxin.tenant.open.domains.dtos.RoomCommunicatedGroupDTO;
import com.bcxin.tenant.open.domains.entities.OrgPurseTransactionEntity;
import com.bcxin.tenant.open.domains.events.PreparedRoomCommunicatedGroupEvent;
import com.bcxin.tenant.open.domains.repositories.ConfigOfBillRepository;
import com.bcxin.tenant.open.domains.services.OrgPurseTransactionService;
import com.bcxin.tenant.open.domains.services.commands.CreateOrgPurseTransactionCommand;
import com.bcxin.tenant.open.domains.utils.OrgPurseTransactionUtil;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class PreparedRoomCommunicatedGroupListener_OrgPurseTransaction
implements ApplicationListener<PreparedRoomCommunicatedGroupEvent> {
    private final Logger logger = LoggerFactory.getLogger(PreparedRoomCommunicatedGroupListener_OrgPurseTransaction.class);
    private final OrgPurseTransactionService orgPurseTransactionService;
    private final IdWorker idWorker;
    private final JsonProvider jsonProvider;
    private final ConfigOfBillRepository configOfBillRepository;

    public PreparedRoomCommunicatedGroupListener_OrgPurseTransaction(OrgPurseTransactionService orgPurseTransactionService, IdWorker idWorker, JsonProvider jsonProvider, ConfigOfBillRepository configOfBillRepository) {
        this.orgPurseTransactionService = orgPurseTransactionService;
        this.idWorker = idWorker;
        this.jsonProvider = jsonProvider;
        this.configOfBillRepository = configOfBillRepository;
    }

    public void onApplicationEvent(PreparedRoomCommunicatedGroupEvent event) {
        Collection<RoomCommunicatedGroupDTO> roomCommunicatedGroups = event.getRoomCommunicatedGroups();
        Collection<OrgPurseTransactionEntity> orgPurseTransactions = OrgPurseTransactionUtil.build(this.idWorker, roomCommunicatedGroups, this.jsonProvider, this.configOfBillRepository.get());
        this.logger.info("\u57fa\u4e8e\u6784\u5efa\u597d\u7684\u623f\u95f4\u7684\u4fe1\u606f\uff0c\u6784\u5efa\u597d\u7684transactions={}", (Object)orgPurseTransactions.size());
        CreateOrgPurseTransactionCommand command = CreateOrgPurseTransactionCommand.create(orgPurseTransactions);
        this.orgPurseTransactionService.dispatch(command);
    }
}

