/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.components;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HotCacheManager {
    private static final Logger logger = LoggerFactory.getLogger(HotCacheManager.class);
    private static final Cache<String, Object> _hotCache = Caffeine.newBuilder().maximumSize(100L).softValues().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    public static final String KEY_ENABLE_FACE_VALIDATION = "FACE_VALIDATION_SETTING";

    public static <T> void put(CacheDataType dataType, String key, T data) {
        try {
            HotCacheManager.getMatchCache(dataType).put((Object)HotCacheManager.getCacheKey(dataType, key), data);
        }
        catch (Exception ex) {
            logger.error("\u5b58\u50a8\u7f13\u5b58\u6570\u636e\u53d1\u751f\u5f02\u5e38:{}", (Object)HotCacheManager.getCacheKey(dataType, key), (Object)ex);
        }
    }

    public static <T> T get(CacheDataType dataType, String key) {
        try {
            return (T)HotCacheManager.getMatchCache(dataType).getIfPresent((Object)HotCacheManager.getCacheKey(dataType, key));
        }
        catch (Exception ex) {
            logger.error("\u83b7\u53d6\u7f13\u5b58\u53d1\u751f\u5f02\u5e38:{}", (Object)HotCacheManager.getCacheKey(dataType, key), (Object)ex);
            return null;
        }
    }

    public static void remove(CacheDataType dataType, String key) {
        try {
            HotCacheManager.getMatchCache(dataType).invalidate((Object)HotCacheManager.getCacheKey(dataType, key));
        }
        catch (Exception ex) {
            logger.error("\u6e05\u9664\u7f13\u5b58\u53d1\u751f\u5f02\u5e38:{}", (Object)HotCacheManager.getCacheKey(dataType, key), (Object)ex);
        }
    }

    private static String getCacheKey(CacheDataType dataType, String key) {
        return String.format("%s_%s", new Object[]{dataType, key});
    }

    private static Cache<String, Object> getMatchCache(CacheDataType dataType) {
        return _hotCache;
    }

    public static Collection<String> getKeys() {
        return _hotCache.asMap().keySet();
    }

    public static enum CacheDataType {
        SecurityStation,
        EnableFaceValidation;

    }
}

