/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.impls;

import com.bcxin.tenant.open.domains.entities.BillStatusCheckpointEntity;
import com.bcxin.tenant.open.domains.entities.DailyBillEntity;
import com.bcxin.tenant.open.domains.entities.MonthlyBillEntity;
import com.bcxin.tenant.open.domains.pojo.DailyBillPojo;
import com.bcxin.tenant.open.domains.repositories.BillStatusCheckpointRepository;
import com.bcxin.tenant.open.domains.repositories.DailyBillRepository;
import com.bcxin.tenant.open.domains.repositories.MonthlyBillRepository;
import com.bcxin.tenant.open.domains.repositories.RdCompanyRepository;
import com.bcxin.tenant.open.domains.services.DailyBillService;
import com.bcxin.tenant.open.domains.services.commands.GenerateDailyBillCommand;
import com.bcxin.tenant.open.domains.utils.BillUtils;
import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.enums.BillPaymentStatus;
import com.bcxin.tenant.open.infrastructures.enums.BillType;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DailyBillServiceImpl
implements DailyBillService {
    Logger logger = LoggerFactory.getLogger(DailyBillServiceImpl.class);
    private final UnitWork unitWork;
    private final DailyBillRepository dailyBillRepository;
    private final MonthlyBillRepository monthlyBillRepository;
    private final RdCompanyRepository rdCompanyRepository;
    private final BillStatusCheckpointRepository billStatusCheckpointRepository;
    public static int BATCH_SIZE = 100;

    public DailyBillServiceImpl(UnitWork unitWork, DailyBillRepository dailyBillRepository, MonthlyBillRepository monthlyBillRepository, RdCompanyRepository rdCompanyRepository, BillStatusCheckpointRepository billStatusCheckpointRepository) {
        this.unitWork = unitWork;
        this.dailyBillRepository = dailyBillRepository;
        this.monthlyBillRepository = monthlyBillRepository;
        this.rdCompanyRepository = rdCompanyRepository;
        this.billStatusCheckpointRepository = billStatusCheckpointRepository;
    }

    @Override
    public void dispatch(GenerateDailyBillCommand command) {
        java.util.Date date = command.getDate();
        Collection<BillType> billTypes = command.getBillTypes();
        if (CollectionUtils.isEmpty(billTypes)) {
            return;
        }
        List<String> orgIds = this.rdCompanyRepository.selectAllCompanyIds();
        Map<String, List<BillStatusCheckpointEntity>> billStatusMap = this.billStatusCheckpointRepository.selectAll(0).stream().collect(Collectors.groupingBy(BillStatusCheckpointEntity::getOrganizationId));
        Map<String, List<DailyBillEntity>> currentDailyBillsMap = this.getAllTypesDailyBills(billTypes, null, date, date).stream().collect(Collectors.groupingBy(DailyBillEntity::getOrgId));
        int index = 0;
        String transactionID = this.unitWork.beginTransaction();
        ArrayList<DailyBillEntity> dailyBillEntityList = new ArrayList<DailyBillEntity>();
        ArrayList<BillStatusCheckpointEntity> insertBillStatusList = new ArrayList<BillStatusCheckpointEntity>();
        ArrayList<BillStatusCheckpointEntity> updateBillStatusList = new ArrayList<BillStatusCheckpointEntity>();
        java.util.Date endDate = BillUtils.getPreviousDate(date);
        for (int i = 0; i < orgIds.size(); ++i) {
            String orgId = orgIds.get(i);
            ++index;
            try {
                if (currentDailyBillsMap.get(orgId) != null) {
                    dailyBillEntityList.addAll((Collection)currentDailyBillsMap.get(orgId));
                }
                java.util.Date fromDate = null;
                List<BillStatusCheckpointEntity> billStatus = billStatusMap.get(orgId);
                if (!CollectionUtils.isEmpty(billStatus)) {
                    fromDate = BillUtils.getNextDate(billStatus.get(0).getLastUpdate());
                }
                if (BillUtils.compareDate(fromDate, endDate) <= 0) {
                    dailyBillEntityList.addAll(this.getAllTypesDailyBills(billTypes, orgId, fromDate, endDate));
                }
                if (CollectionUtils.isEmpty(billStatus)) {
                    insertBillStatusList.add(BillStatusCheckpointEntity.create(null, orgId, 0, null, Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(date))));
                } else {
                    BillStatusCheckpointEntity entity = billStatus.get(0);
                    entity.setLastUpdate(Date.valueOf(new SimpleDateFormat("yyyy-MM-dd").format(date)));
                    updateBillStatusList.add(entity);
                }
                if (index % BATCH_SIZE != 0 && i != orgIds.size() - 1) continue;
                if (!dailyBillEntityList.isEmpty()) {
                    List<String> monthlyBillIds = dailyBillEntityList.stream().map(ix -> ix.getMonthlyBillId()).distinct().collect(Collectors.toList());
                    List<MonthlyBillEntity> existMontlyBills = this.monthlyBillRepository.getByBillId(monthlyBillIds);
                    if (monthlyBillIds.size() != existMontlyBills.size()) {
                        List<MonthlyBillEntity> monthlyBills = dailyBillEntityList.stream().filter(ix -> !existMontlyBills.stream().anyMatch(ii -> ii.getBillId().equals(ix.getMonthlyBillId()))).map(ix -> MonthlyBillEntity.create(ix.getMonthlyBillId(), ix.getType(), ix.getOrgId(), BillPaymentStatus.Unpaid, null, BillUtils.getDateFormat(ix.getDate(), "yyyyMM"), 0, 0, 0, null, 0)).distinct().collect(Collectors.toList());
                        this.monthlyBillRepository.insertEmptyBills(monthlyBills);
                    }
                    this.dailyBillRepository.insert(dailyBillEntityList);
                }
                if (!CollectionUtils.isEmpty(insertBillStatusList)) {
                    this.billStatusCheckpointRepository.insertBatch(insertBillStatusList);
                }
                if (!CollectionUtils.isEmpty(updateBillStatusList)) {
                    this.billStatusCheckpointRepository.updateBatch(updateBillStatusList);
                }
                this.unitWork.commit(transactionID);
                index = 0;
                if (i < orgIds.size() - 1) {
                    transactionID = this.unitWork.beginTransaction();
                }
                dailyBillEntityList.clear();
                insertBillStatusList.clear();
                updateBillStatusList.clear();
                continue;
            }
            catch (Exception e) {
                this.logger.error("\u751f\u6210\u65e5\u8d26\u5355\u53d1\u751f\u5f02\u5e38\u3002organizationId={},date={},exception={}", new Object[]{dailyBillEntityList.stream().map(ix -> ix.getOrgId()).collect(Collectors.toList()), date, e});
                this.unitWork.rollback(transactionID);
                index = 0;
                if (i < orgIds.size() - 1) {
                    transactionID = this.unitWork.beginTransaction();
                }
                dailyBillEntityList.clear();
                insertBillStatusList.clear();
                updateBillStatusList.clear();
            }
        }
    }

    private List<DailyBillEntity> getAllTypesDailyBills(Collection<BillType> billTypes, String orgId, java.util.Date fromDate, java.util.Date endDate) {
        ArrayList<DailyBillEntity> dailyBillEntityList = new ArrayList<DailyBillEntity>();
        block6: for (BillType billType : billTypes) {
            switch (billType) {
                case Attendance: {
                    List<DailyBillPojo> attendaceList = this.dailyBillRepository.getAttendanceBillInfo(orgId, fromDate, endDate);
                    if (attendaceList.isEmpty()) continue block6;
                    List attBillEntityList = attendaceList.stream().map(ix -> BillUtils.createDailyBillEntity(ix, ix.getDate(), BillType.Attendance)).collect(Collectors.toList());
                    dailyBillEntityList.addAll(attBillEntityList);
                    break;
                }
                case RollCall: {
                    List<DailyBillPojo> rollCallList = this.dailyBillRepository.getRollCallBillInfo(orgId, fromDate, endDate);
                    if (rollCallList.isEmpty()) continue block6;
                    List rollCallEntityList = rollCallList.stream().map(ix -> BillUtils.createDailyBillEntity(ix, ix.getDate(), BillType.RollCall)).collect(Collectors.toList());
                    dailyBillEntityList.addAll(rollCallEntityList);
                    break;
                }
                case Track: {
                    List<DailyBillPojo> locationQueries = this.dailyBillRepository.getEmployeeLocationBillInfo(orgId, fromDate, endDate);
                    if (locationQueries.isEmpty()) continue block6;
                    List trackBillEntityList = locationQueries.stream().map(ix -> BillUtils.createDailyBillEntity(ix, ix.getDate(), BillType.Track)).collect(Collectors.toList());
                    dailyBillEntityList.addAll(trackBillEntityList);
                    break;
                }
                case Fence: {
                    List<DailyBillPojo> secStationRailQueries = this.dailyBillRepository.getSecurityStationRailBillInfo(orgId, fromDate, endDate);
                    if (secStationRailQueries.isEmpty()) break;
                    List fenceBillEntityList = secStationRailQueries.stream().map(ix -> BillUtils.createDailyBillEntity(ix, ix.getDate(), BillType.Fence)).collect(Collectors.toList());
                    dailyBillEntityList.addAll(fenceBillEntityList);
                }
            }
        }
        return dailyBillEntityList;
    }
}

