/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RailBusinessType;
import com.bcxin.tenant.open.infrastructures.enums.RailRuleType;
import com.bcxin.tenant.open.infrastructures.enums.RailShapeType;
import com.bcxin.tenant.open.infrastructures.exceptions.NotSupportTenantException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import org.apache.ibatis.type.EnumOrdinalTypeHandler;
import org.apache.ibatis.type.JdbcType;

@TableName(value="rd_security_station_rails", autoResultMap=true)
public class RdSecurityStationRailEntity
extends EntityAbstract
implements Aggregate {
    @TableId(value="pk_id")
    private Long pkId;
    @TableField(value="name")
    private String name;
    @TableField(value="shape_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private RailShapeType shapeType;
    @TableField(value="area_json")
    private String areaJson;
    @TableField(value="business_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private RailBusinessType businessType;
    @TableField(value="reference_number")
    private String referenceNumber;
    @TableField(value="reference_name")
    private String referenceName;
    @TableField(value="begin_time")
    private Date beginTime;
    @TableField(value="end_time")
    private Date endTime;
    @TableField(value="is_deleted")
    private boolean deleted;
    @TableField(value="created_time")
    private Timestamp createdTime;
    @TableField(value="last_updated_time")
    private Timestamp lastUpdatedTime;
    @TableField(value="last_modifier_id")
    private String lastModifierId;
    @TableField(value="creator_id")
    private String creatorId;
    @TableField(value="rule_type", jdbcType=JdbcType.TINYINT, javaType=true, typeHandler=EnumOrdinalTypeHandler.class)
    private RailRuleType ruleType;
    @TableField(value="supervise_depart_id")
    private String superviseDepartId;
    @TableField(value="supervise_depart_name")
    private String superviseDepartName;
    @TableField(value="creator_name")
    private String creatorName;
    @TableField(value="last_modifier_name")
    private String lastModifierName;
    @TableField(value="note")
    private String note;
    @TableField(value="organization_id")
    private String organizationId;
    @TableField(value="owner_organization_id")
    private String ownerOrganizationId;

    protected RdSecurityStationRailEntity() {
    }

    public RdSecurityStationRailEntity(long id, String organizationId, String employeeId, String employeeName, String ownerOrganizationId) {
        this.setPkId(id);
        this.setCreatorId(employeeId);
        this.setOrganizationId(organizationId);
        this.setCreatorName(employeeName);
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setOwnerOrganizationId(ownerOrganizationId);
    }

    public void change(String name, RailShapeType shapeType, String areaJson, RailBusinessType businessType, String referenceNumber, String referenceName, Date beginTime, Date endTime, RailRuleType ruleType, String modifierId, String note, String superviseDepartId, String superviseDepartName, String modifierName) {
        if (ruleType == RailRuleType.Access) {
            throw new NotSupportTenantException(String.format("\u56f4\u680f\u7c7b\u578b\u65e0\u6548,\u76ee\u524d\u4ec5\u652f\u6301\u79bb\u5f00\u544a\u8b66\u7684\u56f4\u680f\u7c7b\u578b", ruleType.name()));
        }
        this.setName(name);
        this.setShapeType(shapeType);
        this.setAreaJson(areaJson);
        this.setBusinessType(businessType);
        this.setReferenceName(referenceName);
        this.setReferenceNumber(referenceNumber);
        this.setBeginTime(beginTime);
        this.setEndTime(endTime);
        this.setRuleType(ruleType);
        this.setNote(note);
        this.setLastModifierId(modifierId);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setSuperviseDepartId(superviseDepartId);
        this.setSuperviseDepartName(superviseDepartName);
        this.setLastModifierName(modifierName);
    }

    public void markAsDeleted(String modifierId, String modifierName) {
        this.setDeleted(true);
        this.setLastModifierId(modifierId);
        this.setLastModifierName(modifierName);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public static RdSecurityStationRailEntity create(long id, String organizationId, String name, RailShapeType shapeType, String areaJson, RailBusinessType businessType, String referenceNumber, String referenceName, Date beginTime, Date endTime, RailRuleType ruleType, String userId, String note, String superviseDepartId, String superviseDepartName, String userName, String ownerOrganizationId) {
        RdSecurityStationRailEntity entity = new RdSecurityStationRailEntity(id, organizationId, userId, userName, ownerOrganizationId);
        entity.setPkId(id);
        entity.change(name, shapeType, areaJson, businessType, referenceNumber, referenceName, beginTime, endTime, ruleType, userId, note, superviseDepartId, superviseDepartName, userName);
        return entity;
    }

    public Long getPkId() {
        return this.pkId;
    }

    public String getName() {
        return this.name;
    }

    public RailShapeType getShapeType() {
        return this.shapeType;
    }

    public String getAreaJson() {
        return this.areaJson;
    }

    public RailBusinessType getBusinessType() {
        return this.businessType;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getLastModifierId() {
        return this.lastModifierId;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public RailRuleType getRuleType() {
        return this.ruleType;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public String getSuperviseDepartName() {
        return this.superviseDepartName;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public String getLastModifierName() {
        return this.lastModifierName;
    }

    public String getNote() {
        return this.note;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getOwnerOrganizationId() {
        return this.ownerOrganizationId;
    }

    public void setPkId(Long pkId) {
        this.pkId = pkId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShapeType(RailShapeType shapeType) {
        this.shapeType = shapeType;
    }

    public void setAreaJson(String areaJson) {
        this.areaJson = areaJson;
    }

    public void setBusinessType(RailBusinessType businessType) {
        this.businessType = businessType;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public void setReferenceName(String referenceName) {
        this.referenceName = referenceName;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public void setLastModifierId(String lastModifierId) {
        this.lastModifierId = lastModifierId;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setRuleType(RailRuleType ruleType) {
        this.ruleType = ruleType;
    }

    public void setSuperviseDepartId(String superviseDepartId) {
        this.superviseDepartId = superviseDepartId;
    }

    public void setSuperviseDepartName(String superviseDepartName) {
        this.superviseDepartName = superviseDepartName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public void setLastModifierName(String lastModifierName) {
        this.lastModifierName = lastModifierName;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setOwnerOrganizationId(String ownerOrganizationId) {
        this.ownerOrganizationId = ownerOrganizationId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RdSecurityStationRailEntity)) {
            return false;
        }
        RdSecurityStationRailEntity other = (RdSecurityStationRailEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        Long this$pkId = this.getPkId();
        Long other$pkId = other.getPkId();
        if (this$pkId == null ? other$pkId != null : !((Object)this$pkId).equals(other$pkId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        RailShapeType this$shapeType = this.getShapeType();
        RailShapeType other$shapeType = other.getShapeType();
        if (this$shapeType == null ? other$shapeType != null : !this$shapeType.equals(other$shapeType)) {
            return false;
        }
        String this$areaJson = this.getAreaJson();
        String other$areaJson = other.getAreaJson();
        if (this$areaJson == null ? other$areaJson != null : !this$areaJson.equals(other$areaJson)) {
            return false;
        }
        RailBusinessType this$businessType = this.getBusinessType();
        RailBusinessType other$businessType = other.getBusinessType();
        if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) {
            return false;
        }
        String this$referenceNumber = this.getReferenceNumber();
        String other$referenceNumber = other.getReferenceNumber();
        if (this$referenceNumber == null ? other$referenceNumber != null : !this$referenceNumber.equals(other$referenceNumber)) {
            return false;
        }
        String this$referenceName = this.getReferenceName();
        String other$referenceName = other.getReferenceName();
        if (this$referenceName == null ? other$referenceName != null : !this$referenceName.equals(other$referenceName)) {
            return false;
        }
        Date this$beginTime = this.getBeginTime();
        Date other$beginTime = other.getBeginTime();
        if (this$beginTime == null ? other$beginTime != null : !((Object)this$beginTime).equals(other$beginTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        Timestamp this$createdTime = this.getCreatedTime();
        Timestamp other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        Timestamp this$lastUpdatedTime = this.getLastUpdatedTime();
        Timestamp other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$lastModifierId = this.getLastModifierId();
        String other$lastModifierId = other.getLastModifierId();
        if (this$lastModifierId == null ? other$lastModifierId != null : !this$lastModifierId.equals(other$lastModifierId)) {
            return false;
        }
        String this$creatorId = this.getCreatorId();
        String other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !this$creatorId.equals(other$creatorId)) {
            return false;
        }
        RailRuleType this$ruleType = this.getRuleType();
        RailRuleType other$ruleType = other.getRuleType();
        if (this$ruleType == null ? other$ruleType != null : !this$ruleType.equals(other$ruleType)) {
            return false;
        }
        String this$superviseDepartId = this.getSuperviseDepartId();
        String other$superviseDepartId = other.getSuperviseDepartId();
        if (this$superviseDepartId == null ? other$superviseDepartId != null : !this$superviseDepartId.equals(other$superviseDepartId)) {
            return false;
        }
        String this$superviseDepartName = this.getSuperviseDepartName();
        String other$superviseDepartName = other.getSuperviseDepartName();
        if (this$superviseDepartName == null ? other$superviseDepartName != null : !this$superviseDepartName.equals(other$superviseDepartName)) {
            return false;
        }
        String this$creatorName = this.getCreatorName();
        String other$creatorName = other.getCreatorName();
        if (this$creatorName == null ? other$creatorName != null : !this$creatorName.equals(other$creatorName)) {
            return false;
        }
        String this$lastModifierName = this.getLastModifierName();
        String other$lastModifierName = other.getLastModifierName();
        if (this$lastModifierName == null ? other$lastModifierName != null : !this$lastModifierName.equals(other$lastModifierName)) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        if (this$note == null ? other$note != null : !this$note.equals(other$note)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$ownerOrganizationId = this.getOwnerOrganizationId();
        String other$ownerOrganizationId = other.getOwnerOrganizationId();
        return !(this$ownerOrganizationId == null ? other$ownerOrganizationId != null : !this$ownerOrganizationId.equals(other$ownerOrganizationId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RdSecurityStationRailEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        Long $pkId = this.getPkId();
        result = result * 59 + ($pkId == null ? 43 : ((Object)$pkId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        RailShapeType $shapeType = this.getShapeType();
        result = result * 59 + ($shapeType == null ? 43 : $shapeType.hashCode());
        String $areaJson = this.getAreaJson();
        result = result * 59 + ($areaJson == null ? 43 : $areaJson.hashCode());
        RailBusinessType $businessType = this.getBusinessType();
        result = result * 59 + ($businessType == null ? 43 : $businessType.hashCode());
        String $referenceNumber = this.getReferenceNumber();
        result = result * 59 + ($referenceNumber == null ? 43 : $referenceNumber.hashCode());
        String $referenceName = this.getReferenceName();
        result = result * 59 + ($referenceName == null ? 43 : $referenceName.hashCode());
        Date $beginTime = this.getBeginTime();
        result = result * 59 + ($beginTime == null ? 43 : ((Object)$beginTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        Timestamp $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        Timestamp $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $lastModifierId = this.getLastModifierId();
        result = result * 59 + ($lastModifierId == null ? 43 : $lastModifierId.hashCode());
        String $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : $creatorId.hashCode());
        RailRuleType $ruleType = this.getRuleType();
        result = result * 59 + ($ruleType == null ? 43 : $ruleType.hashCode());
        String $superviseDepartId = this.getSuperviseDepartId();
        result = result * 59 + ($superviseDepartId == null ? 43 : $superviseDepartId.hashCode());
        String $superviseDepartName = this.getSuperviseDepartName();
        result = result * 59 + ($superviseDepartName == null ? 43 : $superviseDepartName.hashCode());
        String $creatorName = this.getCreatorName();
        result = result * 59 + ($creatorName == null ? 43 : $creatorName.hashCode());
        String $lastModifierName = this.getLastModifierName();
        result = result * 59 + ($lastModifierName == null ? 43 : $lastModifierName.hashCode());
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 43 : $note.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $ownerOrganizationId = this.getOwnerOrganizationId();
        result = result * 59 + ($ownerOrganizationId == null ? 43 : $ownerOrganizationId.hashCode());
        return result;
    }

    public String toString() {
        return "RdSecurityStationRailEntity(pkId=" + this.getPkId() + ", name=" + this.getName() + ", shapeType=" + this.getShapeType() + ", areaJson=" + this.getAreaJson() + ", businessType=" + this.getBusinessType() + ", referenceNumber=" + this.getReferenceNumber() + ", referenceName=" + this.getReferenceName() + ", beginTime=" + this.getBeginTime() + ", endTime=" + this.getEndTime() + ", deleted=" + this.isDeleted() + ", createdTime=" + this.getCreatedTime() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", lastModifierId=" + this.getLastModifierId() + ", creatorId=" + this.getCreatorId() + ", ruleType=" + this.getRuleType() + ", superviseDepartId=" + this.getSuperviseDepartId() + ", superviseDepartName=" + this.getSuperviseDepartName() + ", creatorName=" + this.getCreatorName() + ", lastModifierName=" + this.getLastModifierName() + ", note=" + this.getNote() + ", organizationId=" + this.getOrganizationId() + ", ownerOrganizationId=" + this.getOwnerOrganizationId() + ")";
    }
}

