/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.utils;

import com.bcxin.tenant.open.infrastructures.enums.PoliceEventLevel;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class RedisConstantUtils {
    private static final String SET_POLICE_INCIDENTS_SUPERVISE_DEPART_FORMAT = "dispatch:supervise_depart:%s:%s:police_incidents";

    public static String getPoliceIncidentsSuperviseDepartSetKey(PoliceEventLevel level, String superviseDepartCode) {
        return String.format(SET_POLICE_INCIDENTS_SUPERVISE_DEPART_FORMAT, level, superviseDepartCode);
    }

    public static Collection<String> getPoliceIncidentsSuperviseDepartSetKeys(PoliceEventLevel level, Collection<String> superviseDepartCodes) {
        if (CollectionUtils.isEmpty(superviseDepartCodes)) {
            return Collections.EMPTY_LIST;
        }
        return superviseDepartCodes.stream().map(ix -> RedisConstantUtils.getPoliceIncidentsSuperviseDepartSetKey(level, ix)).collect(Collectors.toList());
    }
}

