/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.impls;

import com.bcxin.tenant.open.document.domains.documents.InstantActivityDataDocument;
import com.bcxin.tenant.open.document.domains.documents.NotifyMessageDocument;
import com.bcxin.tenant.open.document.domains.documents.RdEmployeeDocument;
import com.bcxin.tenant.open.document.domains.documents.RoomDocument;
import com.bcxin.tenant.open.document.domains.documents.messages.MessageContentDocumentAbstract;
import com.bcxin.tenant.open.document.domains.documents.messages.RoomUserActiveMessageContentDocument;
import com.bcxin.tenant.open.document.domains.repositories.InstantActivityDataDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.NotifyMessageDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RdEmployeeDocumentRepository;
import com.bcxin.tenant.open.document.domains.repositories.RoomDocumentRepository;
import com.bcxin.tenant.open.domains.entities.RoomEntity;
import com.bcxin.tenant.open.domains.entities.RoomUserEntity;
import com.bcxin.tenant.open.domains.entities.TenantUserView;
import com.bcxin.tenant.open.domains.repositories.RoomRepository;
import com.bcxin.tenant.open.domains.repositories.TenantUserViewRepository;
import com.bcxin.tenant.open.domains.services.RoomService;
import com.bcxin.tenant.open.domains.services.commands.CloseRoomCommand;
import com.bcxin.tenant.open.domains.services.commands.CreateRoomCommand;
import com.bcxin.tenant.open.domains.services.commands.CreateRoomCommandResponse;
import com.bcxin.tenant.open.domains.services.commands.InviteRoomUserCommand;
import com.bcxin.tenant.open.domains.services.commands.InviteRoomUserCommandResponse;
import com.bcxin.tenant.open.domains.services.commands.RemoveUserCommand;
import com.bcxin.tenant.open.infrastructures.TenantContext;
import com.bcxin.tenant.open.infrastructures.TenantEmployeeContext;
import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.configs.TenantSystemConfig;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import com.bcxin.tenant.open.infrastructures.enums.DeskType;
import com.bcxin.tenant.open.infrastructures.enums.DispatchReasonType;
import com.bcxin.tenant.open.infrastructures.enums.InstantDataType;
import com.bcxin.tenant.open.infrastructures.enums.NotifyMessageType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.NoFoundTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.tenant.open.infrastructures.snapshoots.RoomDispatchSnapshoot;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class RoomServiceImpl
implements RoomService {
    private static final Logger logger = LoggerFactory.getLogger(RoomServiceImpl.class);
    private final RdEmployeeDocumentRepository rdEmployeeDocumentRepository;
    private final NotifyMessageDocumentRepository notifyMessageDocumentRepository;
    private final RoomDocumentRepository roomDocumentRepository;
    private final RoomRepository roomRepository;
    private final IdWorker idWorker;
    private final UnitWork unitWork;
    private final RedisTemplate redisTemplate;
    private final TenantUserViewRepository tenantUserViewRepository;
    private final JsonProvider jsonProvider;
    private final KafkaTemplate kafkaTemplate;
    private final TenantSystemConfig tenantSystemConfig;
    private final InstantActivityDataDocumentRepository instantActivityDataDocumentRepository;

    public RoomServiceImpl(RdEmployeeDocumentRepository rdEmployeeDocumentRepository, NotifyMessageDocumentRepository notifyMessageDocumentRepository, RoomDocumentRepository roomDocumentRepository, RoomRepository roomRepository, IdWorker idWorker, UnitWork unitWork, RedisTemplate redisTemplate, TenantUserViewRepository tenantUserViewRepository, JsonProvider jsonProvider, KafkaTemplate kafkaTemplate, TenantSystemConfig tenantSystemConfig, InstantActivityDataDocumentRepository instantActivityDataDocumentRepository) {
        this.rdEmployeeDocumentRepository = rdEmployeeDocumentRepository;
        this.notifyMessageDocumentRepository = notifyMessageDocumentRepository;
        this.roomDocumentRepository = roomDocumentRepository;
        this.roomRepository = roomRepository;
        this.idWorker = idWorker;
        this.unitWork = unitWork;
        this.redisTemplate = redisTemplate;
        this.tenantUserViewRepository = tenantUserViewRepository;
        this.jsonProvider = jsonProvider;
        this.kafkaTemplate = kafkaTemplate;
        this.tenantSystemConfig = tenantSystemConfig;
        this.instantActivityDataDocumentRepository = instantActivityDataDocumentRepository;
    }

    @Override
    public CreateRoomCommandResponse dispatch(CreateRoomCommand command) {
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new UnAuthorizedTenantException();
        }
        String tranId = this.unitWork.beginTransaction();
        Long roomId = this.getNextId();
        ArrayList<CreateRoomCommandResponse.CreateRoomCommandItem> roomItems = new ArrayList();
        try {
            Collection employeeIds = command.getRoomUsers().stream().map(ix -> ix.getEmployeeId()).collect(Collectors.toList());
            List employeeDocuments = this.rdEmployeeDocumentRepository.findAllById((Iterable)employeeIds);
            ArrayList<RoomDocument.RoomUserDocument> roomUserDocuments = new ArrayList<RoomDocument.RoomUserDocument>();
            ArrayList notifyMessageDocuments = new ArrayList();
            RoomEntity room = RoomEntity.create(roomId, command.getCommunicatedType(), command.getYardmanType(), userModel.getEmployeeId(), userModel.getOrganizationId(), command.getReferenceType(), command.getReferenceNumber(), command.getDeskType());
            Collection tenantUserIds = employeeDocuments.stream().map(ix -> ix.getTenantUserId()).distinct().collect(Collectors.toList());
            Collection<TenantUserView> tenantUserViews = this.tenantUserViewRepository.getAllByIds(tenantUserIds);
            command.getRoomUsers().forEach(ru -> this.addRoomUsers(notifyMessageDocuments, employeeDocuments, (Collection<RoomDocument.RoomUserDocument>)roomUserDocuments, room, tenantUserViews, (CreateRoomCommand.CreateRoomUserCommand)((Object)ru), userModel));
            this.handleInvalidRoomUsers(roomUserDocuments);
            RoomDocument document = RoomDocument.create((Long)roomId, (DeskType)room.getDeskType(), (String)room.getOrganizationId(), (String)room.getEmployeeId(), (CommunicatedType)room.getCommunicatedType(), (int)room.getYardmanType(), (DispatchReasonType)room.getReferenceType(), (String)room.getReferenceNumber(), roomUserDocuments);
            this.notifyMessageDocumentRepository.saveAll(notifyMessageDocuments);
            this.roomDocumentRepository.save((Object)document);
            this.roomRepository.insert(room);
            if (room.getReferenceType() == DispatchReasonType.RollCall) {
                String referenceNumber = String.valueOf(room.getId());
                String rollCallId = room.getReferenceNumber();
                Collection activityDataDocuments = roomUserDocuments.stream().map(ii -> InstantActivityDataDocument.create((InstantDataType)InstantDataType.Dispatch, (String)referenceNumber, (String)ii.getEmployeeId(), (String)rollCallId)).collect(Collectors.toList());
                this.instantActivityDataDocumentRepository.saveAll((Iterable)activityDataDocuments);
                try {
                    RoomDispatchSnapshoot roomDispatchPoJo = RoomDispatchSnapshoot.create((Long)room.getId(), (DispatchReasonType)room.getReferenceType(), (String)room.getReferenceNumber(), (Collection)roomUserDocuments.stream().map(ii -> ii.getEmployeeId()).collect(Collectors.toList()));
                    String rollCallRoomJson = this.jsonProvider.getJson((Object)roomDispatchPoJo);
                    String rollCallRoomJsonKey = String.valueOf(roomDispatchPoJo.getReferenceNumber());
                    int partition = Math.abs(rollCallRoomJsonKey.hashCode() % 3);
                    this.kafkaTemplate.send("dispatch.roll.call.room.employee.topic-v2", Integer.valueOf(partition), (Object)rollCallRoomJsonKey, (Object)rollCallRoomJson);
                }
                catch (Exception ex) {
                    logger.error("Failed to dispatch TOPIC_DISPATCH_ROLL_CALL_EMPLOYEE_ROOM({}) message to topic", (Object)roomId, (Object)ex);
                }
            }
            this.unitWork.commit(tranId);
            roomItems = roomUserDocuments.stream().map(ii -> {
                CreateRoomCommandResponse.CreateRoomCommandItem commandItem = CreateRoomCommandResponse.CreateRoomCommandItem.create(ii.getEmployeeId(), ii.getTenantUserId(), ii.getCid());
                return commandItem;
            }).collect(Collectors.toList());
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
        return CreateRoomCommandResponse.create(roomId, roomItems);
    }

    @Override
    public InviteRoomUserCommandResponse dispatch(InviteRoomUserCommand command) {
        TenantEmployeeContext.TenantUserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new UnAuthorizedTenantException();
        }
        Optional roomDocumentOptional = this.roomDocumentRepository.findById((Object)command.getRoomId());
        if (!roomDocumentOptional.isPresent()) {
            throw new NoFoundTenantException("\u623f\u95f4\u65e0\u6548!");
        }
        String tranId = this.unitWork.beginTransaction();
        RoomDocument roomDocument = (RoomDocument)roomDocumentOptional.get();
        ArrayList<InviteRoomUserCommandResponse.InviteUsersCommandResponseItem> roomUserItems = new ArrayList();
        try {
            Collection employeeIds = command.getRoomUsers().stream().map(ix -> ix.getEmployeeId()).collect(Collectors.toList());
            List employeeDocuments = this.rdEmployeeDocumentRepository.findAllById((Iterable)employeeIds);
            ArrayList<RoomDocument.RoomUserDocument> roomUserDocuments = new ArrayList<RoomDocument.RoomUserDocument>();
            ArrayList<NotifyMessageDocument> notifyMessageDocuments = new ArrayList<NotifyMessageDocument>();
            Collection tenantUserIds = employeeDocuments.stream().map(ix -> ix.getTenantUserId()).distinct().collect(Collectors.toList());
            Collection<TenantUserView> tenantUserViews = this.tenantUserViewRepository.getAllByIds(tenantUserIds);
            for (InviteRoomUserCommand.InviteUserCommandItem ru : command.getRoomUsers()) {
                this.addInviteRoomUsers(notifyMessageDocuments, employeeDocuments, roomUserDocuments, roomDocument, tenantUserViews, ru, userModel.getTencentUserId());
            }
            this.handleInvalidRoomUsers(roomUserDocuments);
            Collection newInviteRoomUserDoc = roomUserDocuments.stream().filter(ix -> roomDocument.getRoomUsers().stream().allMatch(rd -> !rd.getEmployeeId().equals(ix.getEmployeeId()))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)newInviteRoomUserDoc)) {
                roomDocument.getRoomUsers().addAll(newInviteRoomUserDoc);
                this.roomDocumentRepository.save((Object)roomDocument);
            }
            Collection roomUserEntities = roomUserDocuments.stream().map(ix -> RoomUserEntity.create(command.getRoomId(), this.idWorker.getNextId(), ix.getEmployeeId(), ix.getTenantUserId(), ix.getCid(), ix.getEmployeeName(), ix.getOrganizationId(), ix.getOrganizationName(), ix.getTencentUserId(), ix.getSecurityStationId(), ix.getSecurityStationName(), ix.getSuperviseDepartId(), ix.isSponsor(), false)).collect(Collectors.toList());
            this.roomRepository.addRoomUsers(roomUserEntities);
            this.notifyMessageDocumentRepository.saveAll(notifyMessageDocuments);
            this.unitWork.commit(tranId);
            roomUserItems = roomUserDocuments.stream().map(ii -> {
                InviteRoomUserCommandResponse.InviteUsersCommandResponseItem commandItem = InviteRoomUserCommandResponse.InviteUsersCommandResponseItem.create(ii.getEmployeeId(), ii.getEmployeeName(), ii.getTenantUserId(), ii.getCid());
                return commandItem;
            }).collect(Collectors.toList());
        }
        catch (Exception ex) {
            this.unitWork.rollback(tranId);
            throw ex;
        }
        return InviteRoomUserCommandResponse.create(command.getRoomId(), roomUserItems);
    }

    @Override
    public void dispatch(CloseRoomCommand command) {
        Optional roomDocumentOptional = this.roomDocumentRepository.findById((Object)command.getId());
        if (!roomDocumentOptional.isPresent()) {
            throw new NoFoundTenantException("\u8be5\u623f\u95f4\u65e0\u6548");
        }
        RoomDocument document = (RoomDocument)roomDocumentOptional.get();
        if (!command.getOrganizationId().equalsIgnoreCase(document.getOrganizationId())) {
            throw new NoFoundTenantException("\u8be5\u4f01\u4e1a\u672a\u521b\u5efa\u8be5\u623f\u95f4");
        }
        document.leave();
        this.roomDocumentRepository.save((Object)document);
        RoomEntity room = (RoomEntity)this.roomRepository.getById(command.getId());
        if (room != null) {
            String tranId = this.unitWork.beginTransaction();
            try {
                room.leave();
                this.roomRepository.update(room);
                this.unitWork.commit(tranId);
            }
            catch (Exception ex) {
                this.unitWork.rollback(tranId);
                logger.error("\u89e3\u6563\u623f\u95f4\u53d1\u751f\u5f02\u5e38:{}", (Throwable)ex);
            }
        }
    }

    @Override
    public void dispatch(RemoveUserCommand command) {
        Optional roomDocumentOptional = this.roomDocumentRepository.findById((Object)command.getRoomId());
        if (!roomDocumentOptional.isPresent()) {
            throw new NoFoundTenantException("\u8be5\u623f\u95f4\u65e0\u6548");
        }
        RoomDocument roomDocument = (RoomDocument)roomDocumentOptional.get();
        if (CollectionUtils.isEmpty((Collection)roomDocument.getRoomUsers())) {
            throw new NoFoundTenantException("\u8be5\u623f\u95f4\u65e0\u6548\uff0c\u65e0\u53c2\u4f1a\u4eba\u5458");
        }
        Collection roomUserDocuments = roomDocument.getRoomUsers();
        if (!roomUserDocuments.stream().anyMatch(ix -> ix.getTencentUserId().equals(command.getTencentUserId()))) {
            throw new NoFoundTenantException("\u8be5\u4eba\u5458\u4e0d\u5728\u4f1a\u8bae\u623f\u95f4\u5185");
        }
        Optional<RoomDocument.RoomUserDocument> roomUserOptional = roomUserDocuments.stream().filter(ix -> ix.getTencentUserId().equals(command.getTencentUserId())).findFirst();
        if (roomUserOptional.isPresent()) {
            String transId = this.unitWork.beginTransaction();
            try {
                this.roomRepository.removeUsers(command.getRoomId(), Lists.newArrayList((Object[])new String[]{command.getTencentUserId()}));
                roomUserDocuments.remove(roomUserOptional.get());
                this.roomDocumentRepository.save((Object)roomDocument);
                this.unitWork.commit(transId);
            }
            catch (Exception ex) {
                this.unitWork.rollback(transId);
                logger.error("\u79fb\u9664\u4eba\u5458\u5f02\u5e38\uff1a{}", (Throwable)ex);
            }
        }
    }

    private Long getNextId() {
        String prefixRoomNo = this.tenantSystemConfig.getPrefixRoomNo();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMdd");
        String value = dateFormat.format(new Date());
        String key = String.format("room-%s-%s", prefixRoomNo, value);
        Long incValue = this.redisTemplate.opsForValue().increment((Object)key);
        if (incValue == 1L) {
            this.redisTemplate.expire((Object)key, 2L, TimeUnit.DAYS);
        }
        String finalValue = value.concat(StringUtil.leftPad((String)incValue.toString(), (int)3));
        return Long.parseLong(String.format("1%s%s", prefixRoomNo, finalValue));
    }

    private void handleInvalidRoomUsers(Collection<RoomDocument.RoomUserDocument> roomUserDocuments) {
        Collection invalidRoomUsers = roomUserDocuments.stream().filter(ix -> !StringUtils.hasLength((String)ix.getTencentUserId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)invalidRoomUsers)) {
            if (invalidRoomUsers.stream().anyMatch(ix -> ix.isSponsor())) {
                throw new BadTenantException(String.format("\u8be5\u7528\u6237(%s)\u65e0\u8c03\u5ea6\u6743\u9650", invalidRoomUsers.stream().map(ix -> ix.getEmployeeName()).findFirst().get()));
            }
            String dispatchedUserNames = invalidRoomUsers.stream().map(ii -> String.format("%s-%s(%s)", ii.getOrganizationName(), ii.getEmployeeName(), ii.isSponsor() ? "\u8c03\u5ea6\u53f0" : "\u88ab\u8c03\u5ea6\u4eba")).collect(Collectors.joining(";"));
            if (StringUtils.hasLength((String)dispatchedUserNames)) {
                throw new BadTenantException(String.format("%s \u672a\u767b\u5165\u8fc7app, \u56e0\u6b64, \u65e0\u6cd5\u8fdb\u884c\u8c03\u5ea6", dispatchedUserNames));
            }
        }
    }

    private void addRoomUsers(Collection<NotifyMessageDocument> notifyMessageDocuments, Collection<RdEmployeeDocument> employeeDocuments, Collection<RoomDocument.RoomUserDocument> roomUserDocuments, RoomEntity room, Collection<TenantUserView> tenantUserViews, CreateRoomCommand.CreateRoomUserCommand ru, TenantEmployeeContext.TenantUserModel userModel) {
        Optional<RdEmployeeDocument> employeeDocumentOptional = employeeDocuments.stream().filter(ix -> ix.getId().equals(ru.getEmployeeId())).findFirst();
        String employeeName = "#";
        String companyName = "#";
        String stationName = "#";
        String cid = "#";
        String tenantUserId = "#";
        if (employeeDocumentOptional.isPresent()) {
            RdEmployeeDocument employeeDocument = employeeDocumentOptional.get();
            employeeName = employeeDocument.getName();
            companyName = employeeDocument.getCompanyName();
            stationName = employeeDocument.getSecurityStationName();
            tenantUserId = employeeDocument.getTenantUserId();
            Optional<TenantUserView> selectedTenantUserViewOptional = tenantUserViews.stream().filter(tu -> tu.getId().equalsIgnoreCase(employeeDocument.getTenantUserId())).findFirst();
            cid = employeeDocument.getCId();
            if (selectedTenantUserViewOptional.isPresent() && !StringUtil.isEmpty((String)selectedTenantUserViewOptional.get().getCid())) {
                cid = selectedTenantUserViewOptional.get().getCid();
            }
        } else if (ru.isSponsor()) {
            cid = "Sponsor\u8c03\u5ea6\u4eba\u65e0\u9700Cid";
        } else {
            throw new BadTenantException(String.format("\u627e\u4e0d\u5230\u8be5\u7528\u6237:%s", ru.getEmployeeId()));
        }
        if (StringUtil.isEmpty((String)cid)) {
            cid = "-";
        }
        String tencentUserId = userModel.getTencentUserId();
        boolean isSuperviseDepartRole = false;
        if (ru.isSponsor()) {
            isSuperviseDepartRole = userModel.isSuperviseDepartRole();
        }
        room.addUser(this.idWorker.getNextId(), ru.getEmployeeId(), tenantUserId, employeeName, ru.getOrganizationId(), companyName, ru.getTencentUserId(), ru.getSecurityStationId(), stationName, ru.getSuperviseDepartId(), cid, ru.isSponsor(), isSuperviseDepartRole);
        roomUserDocuments.add(RoomDocument.RoomUserDocument.create((String)ru.getEmployeeId(), (String)tenantUserId, (String)employeeName, (String)ru.getOrganizationId(), (String)companyName, (String)ru.getTencentUserId(), (String)ru.getSecurityStationId(), (String)stationName, (String)ru.getSuperviseDepartId(), (String)cid, (boolean)ru.isSponsor()));
        if (!ru.isSponsor()) {
            RoomUserActiveMessageContentDocument data = RoomUserActiveMessageContentDocument.create((Long)this.idWorker.getNextId(), (String)tencentUserId, (String)ru.getEmployeeId(), (String)ru.getTencentUserId(), (String)employeeName, (String)ru.getOrganizationId(), (String)String.valueOf(room.getId()), (CommunicatedType)room.getCommunicatedType(), (int)room.getYardmanType());
            NotifyMessageDocument messageDocument = NotifyMessageDocument.create((JsonProvider)this.jsonProvider, (NotifyMessageType)NotifyMessageType.Dispatch, (String)String.valueOf(data.getId()), (String)String.valueOf(data.getRoomNo()), (String)ru.getEmployeeId(), (MessageContentDocumentAbstract)data);
            notifyMessageDocuments.add(messageDocument);
        }
    }

    private void addInviteRoomUsers(Collection<NotifyMessageDocument> notifyMessageDocuments, Collection<RdEmployeeDocument> employeeDocuments, Collection<RoomDocument.RoomUserDocument> roomUserDocuments, RoomDocument room, Collection<TenantUserView> tenantUserViews, InviteRoomUserCommand.InviteUserCommandItem ru, String tencentUserId) {
        RdEmployeeDocument document = employeeDocuments.stream().filter(ix -> ix.getId().equals(ru.getEmployeeId())).findFirst().orElse(null);
        if (document == null) {
            throw new BadTenantException(String.format("\u627e\u4e0d\u5230\u8be5\u7528\u6237:%s", ru.getEmployeeId()));
        }
        String employeeName = document.getName();
        String companyName = document.getCompanyName();
        String stationName = document.getSecurityStationName();
        String tenantUserId = document.getTenantUserId();
        TenantUserView selectedTenantUserView = tenantUserViews.stream().filter(tu -> tu.getId().equalsIgnoreCase(document.getTenantUserId())).findFirst().orElse(null);
        if (selectedTenantUserView == null) {
            throw new BadTenantException(String.format("\u7cfb\u7edf\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7528\u6237(%s) \u767b\u5165APP\u540e\u5728\u91cd\u65b0\u8c03\u5ea6", document.getName()));
        }
        String cid = selectedTenantUserView.getCid();
        roomUserDocuments.add(RoomDocument.RoomUserDocument.create((String)ru.getEmployeeId(), (String)tenantUserId, (String)employeeName, (String)ru.getOrganizationId(), (String)companyName, (String)ru.getTencentUserId(), (String)ru.getSecurityStationId(), (String)stationName, (String)ru.getSuperviseDepartId(), (String)cid, (boolean)false));
        Long id = this.idWorker.getNextId();
        notifyMessageDocuments.add(NotifyMessageDocument.create((JsonProvider)this.jsonProvider, (NotifyMessageType)NotifyMessageType.Dispatch, (String)String.valueOf(id), (String)String.valueOf(room.getId()), (String)ru.getEmployeeId(), (MessageContentDocumentAbstract)RoomUserActiveMessageContentDocument.create((Long)id, (String)tencentUserId, (String)ru.getEmployeeId(), (String)ru.getTencentUserId(), (String)employeeName, (String)ru.getOrganizationId(), (String)String.valueOf(room.getId()), (CommunicatedType)room.getCommunicatedType(), (int)room.getYardmanType())));
    }
}

