/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.commands;

import com.bcxin.tenant.open.infrastructures.commands.CommandAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RailRuleType;
import com.bcxin.tenant.open.infrastructures.enums.RailShapeType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.infrastructures.valueTypes.RdSecurityStationRailSnapshootValueType;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;

public class CreateRdSecurityStationRailCommand
extends CommandAbstract {
    private final String name;
    private final RailShapeType shapeType;
    private final RdSecurityStationRailSnapshootValueType.ShapedLocationValueType shapedLocation;
    private final String stationId;
    private final boolean fromStationManagement;
    private final String stationName;
    private final String superviseDepartId;
    private final String superviseDepartName;
    private final Date beginTime;
    private final Date endTime;
    private final RailRuleType ruleType;
    private final String note;
    private final String ownerOrganizationId;

    public void validate() {
        super.validate();
        if (this.getShapeType() == null) {
            throw new BadTenantException("\u5f62\u72b6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.getRuleType() == null) {
            throw new BadTenantException("\u56f4\u680f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.getShapeType() != RailShapeType.Circle && (CollectionUtils.isEmpty((Collection)this.getShapedLocation().getGeos()) || this.getShapedLocation().getGeos().size() < 3)) {
            throw new BadTenantException("\u65e0\u6548\u7535\u5b50\u56f4\u680f\u5750\u6807\u53c2\u6570(\u5982\u679c\u7535\u5b50\u56f4\u680f\u7684\u5f62\u72b6\u662f\u975e\u5706\u5f62, \u90a3\u4e48\u5fc5\u987b\u63d0\u4f9b\u4e0d\u5c11\u4e8e\u4e09\u4e2a\u5750\u6807)");
        }
        if (!StringUtil.isEmpty((String)this.getNote()) && this.getNote().length() > 500) {
            throw new BadTenantException("\u7535\u5b50\u56f4\u680f\u5907\u6ce8\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e500\u5b57\u7b26");
        }
        if (this.isFromStationManagement()) {
            if (StringUtil.isEmpty((String)this.getStationName())) {
                throw new BadTenantException("\u9a7b\u52e4\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)this.getSuperviseDepartId()) || StringUtil.isEmpty((String)this.getSuperviseDepartName())) {
                throw new BadTenantException("\u76d1\u7ba1\u5f52\u5c5e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    public CreateRdSecurityStationRailCommand(String name, RailShapeType shapeType, RdSecurityStationRailSnapshootValueType.ShapedLocationValueType shapedLocation, String stationId, boolean fromStationManagement, String stationName, String superviseDepartId, String superviseDepartName, Date beginTime, Date endTime, RailRuleType ruleType, String note, String ownerOrganizationId) {
        this.name = name;
        this.shapeType = shapeType;
        this.shapedLocation = shapedLocation;
        this.stationId = stationId;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.ruleType = ruleType;
        this.note = note;
        this.stationName = stationName;
        this.superviseDepartId = superviseDepartId;
        this.superviseDepartName = superviseDepartName;
        this.fromStationManagement = fromStationManagement;
        this.ownerOrganizationId = ownerOrganizationId;
    }

    public static CreateRdSecurityStationRailCommand create(String name, RailShapeType shapeType, RdSecurityStationRailSnapshootValueType.ShapedLocationValueType shapedLocation, String stationId, boolean fromStationManagement, String stationName, String superviseDepartId, String superviseDepartName, Date beginTime, Date endTime, RailRuleType ruleType, String note, String ownerOrganizationId) {
        return new CreateRdSecurityStationRailCommand(name, shapeType, shapedLocation, stationId, fromStationManagement, stationName, superviseDepartId, superviseDepartName, beginTime, endTime, ruleType, note, ownerOrganizationId);
    }

    public String getName() {
        return this.name;
    }

    public RailShapeType getShapeType() {
        return this.shapeType;
    }

    public RdSecurityStationRailSnapshootValueType.ShapedLocationValueType getShapedLocation() {
        return this.shapedLocation;
    }

    public String getStationId() {
        return this.stationId;
    }

    public boolean isFromStationManagement() {
        return this.fromStationManagement;
    }

    public String getStationName() {
        return this.stationName;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public String getSuperviseDepartName() {
        return this.superviseDepartName;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public RailRuleType getRuleType() {
        return this.ruleType;
    }

    public String getNote() {
        return this.note;
    }

    public String getOwnerOrganizationId() {
        return this.ownerOrganizationId;
    }
}

