package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.BillType;
import lombok.Data;

import java.util.Collection;
import java.util.Date;

@Data
public class MonthlyBillWriteRequest extends RequestAbstract{
    private Date date;
    private Collection<BillType> billTypes;
    private MonthlyBillWriteRequest(Date date, Collection<BillType> billTypes){
        this.date = date;
        this.billTypes = billTypes;
    }

    public static MonthlyBillWriteRequest create(Date date,Collection<BillType> billTypes){
        return new MonthlyBillWriteRequest(date,billTypes);
    }
}
