package com.bcxin.tenant.open.jdks.requests;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;
import java.util.Date;

@Schema(name = "AttendanceSearchRequest",title = "AttendanceSearchRequest 高级筛选条件")
@Data
public class AttendanceSearchRequest extends SearchDeskRequestAbstract {
    @Schema(name = "name", title = "人员姓名")
    private String name;
    @Schema(name = "companyName", title = "公司名称")
    private String companyName;
    @Schema(name = "securityStationName", title = "驻勤点名称")
    private String securityStationName;
    @Schema(name = "superviseDepartIds", title = "监管机构ID")
    private Collection<String> superviseDepartIds;
    @Schema(name = "createdStarDate", title = "签到日期 开始 yyyy-MM-dd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date createdStarDate;
    @Schema(name = "createdEndDate", title = "签到日期 结束 yyyy-MM-dd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private Date createdEndDate;
    @Schema(name = "idCardNo", title = "身份证号")
    private String idCardNo;
    @Schema(name = "searchModel",title = "搜索模式: AdvanceSearch 则表示高级搜索; 仅高级搜索可以; Today  则表示搜索今天记录; RecentWeek  则表示搜索近一周记录; RecentMonth 则表示搜索近一个月记录")
    private SearchModel searchModel;
    @Schema(name = "projectIds", title = "项目Ids")
    private Collection<String> projectIds;

    public static enum SearchModel {
        AdvanceSearch,
        Today,
        RecentWeek,
        RecentMonth
    }
}
