package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.open.infrastructures.enums.DutySignInType;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.infrastructures.valueTypes.GeoLocationValueType;
import com.bcxin.tenant.open.jdks.requests.EmployeeSearchRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.util.Set;

@Schema(name = "EmployeeOverviewResponse",title = "EmployeeOverviewResponse 保安员列表的基本信息")
@Getter
@JsonInclude(JsonInclude.Include.NON_NULL)
public class EmployeeOverviewResponse extends ResponseAbstract {
    @Schema(name = "id", title = "2.保安员id")
    private final String id;
    @Schema(name = "name;", title = "保安员姓名")
    private final String name;

    @Schema(name = "idCardNo", title = "保安员身份证")
    private final String idCardNo;
    @Schema(name = "contact", title = "保安员联系方式")
    private final String contact;

    @Schema(name = "dutyStatus", title = "保安员签到状态; None: 离岗(未签到/离开驻勤点); SignIn: 在岗; SignOut: 离岗(签退/离开驻勤点)")
    private final DutySignInType dutyStatus;

    @Schema(name = "dutyStatusText", title = "签到的文本描述; 保安员签到状态; None: 离岗(未签到/离开驻勤点); SignIn: 在岗; SignOut: 离岗(签退/离开驻勤点)")
    private String dutyStatusText;

    @Schema(name = "securityStationId", title = "驻勤点Id")
    private final String securityStationId;

    @Schema(name = "securityStationName", title = "驻勤点名称")
    private final String securityStationName;

    @Schema(name = "organizationId", title = "企业organizationId")
    private final String organizationId;

    @Schema(name = "companyName", title = "所在公司")
    private final String companyName;

    @Schema(name = "latitude", title = "保安员所在y轴坐标")
    private final Double latitude;

    @Schema(name = "longitude", title = "保安员所在x轴坐标")
    private final Double longitude;

    @Schema(name = "tencentUserId", title = "音视频的腾讯UserId")
    private final String tencentUserId;

    @Schema(name = "tenantImUserId", title = "用户本身的腾讯UserId")
    private final String tenantImUserId;

    @Schema(name = "cid", title = "APP设备Cid的值")
    private final String cid;

    @Schema(name = "isDevice", title = "是否为硬件设备")
    private final Boolean isDevice;

    private final Set<String> followedDeviceNos;

    @Schema(name = "isFollowed", title = "是否关注")
    private final Boolean followed;

    /**
     * 没有加的话,默认返回给前端的是device
     *
     * @return
     */
    public Boolean getIsDevice() {
        if (this.getSearchModel() == EmployeeSearchRequest.SearchModel.SecurityResource) {
            return null;
        }

        return this.isDevice;
    }

    @Schema(name = "hasResource", title = "是否具有调度资源")
    private Boolean hasResource;

    @Schema(name = "superviseDepartId", title = "所属监管归属Id")
    private final String superviseDepartId;

    @Schema(name = "stationResponsible", title = "是否为驻勤点负责人")
    private final boolean stationResponsible;

    @Schema(name = "responsibleOfStationId", title = "所负责的驻勤点Id")
    private final String responsibleOfStationId;

    @Schema(name = "rts", title = "资源类型: Security=保安;Population=社会力量;Proprietor=内保单位的甲方管理员;ProprietorManaged=内保单位管理的保安人员")
    private final Set<String> rts;

    @Schema(name = "proprietorCompanyId", title = "所服务的内保单位Id")
    private  final String proprietorCompanyId;

    @Schema(name = "proprietorCompanyName", title = "所服务的内保单位信息")
    private  final String proprietorCompanyName;

    @JsonIgnore
    private EmployeeSearchRequest.SearchModel searchModel;

    @Schema(name = "projectName", title = "项目名称")
    private final String projectName;

    @Schema(name = "stationType", title = "所在岗点的类型: 比如：马拉松中, 此值作为工作人员类型的Id;可以用于获取工作类型的名称")
    private final String stationType;

    public EmployeeOverviewResponse(
            EmployeeSearchRequest.SearchModel searchMode,
            String id,
            String organizationId,
            String name, String idCardNo,
            String contact,
            String securityStationName,
            String companyName, Double latitude,
            Double longitude,
            DutySignInType dutyStatus,
            Boolean dispatchable,
            String tencentUserId,
            String tenantImUserId,
            String superviseDepartId,
            String securityStationId,
            boolean isDevice,
            String cid,
            Set<String> followedDeviceNos,
            boolean followed,
            String responsibleOfStationId,
            Set<String> resourceTypes,
            String proprietorCompanyId,
            String proprietorCompanyName,
            String projectId,
            String projectName,
            String stationType) {
        this.searchModel = searchMode;
        this.id = id;
        if (GeoLocationValueType.isValidLocation(latitude, longitude)) {
            this.latitude = latitude;
            this.longitude = longitude;
        } else {
            this.latitude = null;
            this.longitude = null;
        }


        if( dutyStatus==DutySignInType.SignIn) {
            if (dispatchable!=null && !dispatchable) {
                this.dutyStatus = DutySignInType.SignOut;
            }else {
                this.dutyStatus = dutyStatus;
            }
        }else {
            this.dutyStatus = dutyStatus;
        }

        this.rts = resourceTypes;

        if (searchMode != EmployeeSearchRequest.SearchModel.SecurityResource) {
            this.dutyStatusText = (this.dutyStatus == DutySignInType.SignIn) ? "在岗" : "离岗";
            this.idCardNo = StringUtil.isEmpty(idCardNo) ? "" : idCardNo;
            this.contact = StringUtil.isEmpty(contact) ? "" : contact;

            this.projectName = projectName;
            this.stationType = stationType;
            this.name = name;
            this.organizationId = organizationId;
            this.companyName = companyName;
            this.cid = cid;
            this.tencentUserId = tencentUserId;
            this.tenantImUserId = tenantImUserId;

            this.securityStationId = securityStationId;
            this.securityStationName = StringUtil.isEmpty(securityStationName) ? "" : securityStationName;
            this.superviseDepartId = superviseDepartId;
            this.isDevice = isDevice;
            this.followedDeviceNos = followedDeviceNos;
            this.followed = followed;
            this.responsibleOfStationId = responsibleOfStationId;
            this.hasResource = (this.getTencentUserId() != null && this.getTencentUserId().length() > 0);

            this.proprietorCompanyId = proprietorCompanyId;
            this.proprietorCompanyName = proprietorCompanyName;
        } else {
            this.projectName=null;
            this.stationType = stationType;
            this.dutyStatusText = null;
            this.idCardNo = null;
            this.contact = null;
            this.companyName = null;
            this.cid = null;
            this.name = null;
            this.organizationId = null;
            this.tencentUserId = null;
            this.tenantImUserId = null;

            this.securityStationId = null;
            this.securityStationName = null;
            this.superviseDepartId = null;
            this.isDevice = null;
            this.followedDeviceNos = null;
            this.followed = null;
            this.hasResource = null;
            this.responsibleOfStationId = null;

            this.proprietorCompanyId = null;
            this.proprietorCompanyName = null;
        }

        this.stationResponsible = !StringUtil.isEmpty(responsibleOfStationId) && !BusinessConstants.DefaultEmptyValue.equalsIgnoreCase(responsibleOfStationId);
    }

    public static EmployeeOverviewResponse create(
            EmployeeSearchRequest.SearchModel searchMode,
            String id,
            String organizationId,
            String name, String idCardNo,
            String contact,
            String securityStationName,
            String companyName, Double latitude,
            Double longitude,
            DutySignInType dutyStatus,
            Boolean dispatchable,
            String tencentUserId,
            String tenantImUserId,
            String superviseDepartId,
            String securityStationId,
            boolean isDevice,
            String cid,
            Set<String> followedDeviceNos,
            boolean followed,
            String responsibleOfStationId,
            Set<String> resourceTypes,
            String proprietorCompanyId,
            String proprietorCompanyName,
            String projectId,
            String projectName,
            String stationType) {
        return new EmployeeOverviewResponse(
                searchMode,
                id, organizationId,
                name, idCardNo, contact, securityStationName, companyName, latitude, longitude,
                dutyStatus, dispatchable,
                tencentUserId, tenantImUserId, superviseDepartId,
                securityStationId, isDevice, cid, followedDeviceNos,
                followed, responsibleOfStationId, resourceTypes,
                proprietorCompanyId, proprietorCompanyName,projectId,projectName, stationType);
    }
}
