/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;

@Schema(name="ProjectAdvanceSearchResponse", title="\u4e1a\u52a1\u7ba1\u7406-\u9ad8\u7ea7\u9879\u76ee\u4fe1\u606f")
public class ProjectResponse
extends ResponseAbstract {
    @Schema(name="pkId", title="pkId")
    private final Long pkId;
    @Schema(name="id", title="id")
    private final String id;
    @Schema(name="name", title="\u9879\u76ee\u540d\u79f0")
    private final String name;
    @Schema(name="type", title="\u9879\u76ee\u7c7b\u578b")
    private final String type;
    @Schema(name="statusLabel", title="\u9879\u76ee\u72b6\u6001")
    private final String statusLabel;
    @Schema(name="principalName", title="\u8d1f\u8d23\u4eba")
    private final String principalName;
    @Schema(name="organizationId", title="\u4f01\u4e1aId")
    private final String organizationId;
    @Schema(name="companyName", title="\u4f01\u4e1a\u540d\u79f0")
    private final String companyName;
    @Schema(name="address", title="\u9879\u76ee\u5730\u5740")
    private final String address;
    @Schema(name="countOfMembers", title="\u6210\u5458\u6570\u91cf")
    private final int countOfMembers;
    @Schema(name="countOfTeams", title="\u56e2\u961f\u6570\u91cf")
    private final int countOfTeams;
    @Schema(name="beginDate", title="\u5f00\u59cb\u65f6\u95f4")
    private final String beginDate;
    @Schema(name="endDate", title="\u7ed3\u675f\u65f6\u95f4")
    private final String endDate;
    @Schema(name="countOfStations", title="\u5c97\u70b9\u6570\u91cf")
    private final long countOfStations;

    public ProjectResponse(Long pkId, String id, String name, String type, String principalName, String organizationId, String companyName, String address, int countOfMembers, int countOfTeams, Date beginDate, Date endDate, long countOfStations) {
        this.pkId = pkId;
        this.id = id;
        this.name = name;
        this.type = type;
        this.principalName = principalName;
        this.organizationId = organizationId;
        this.companyName = companyName;
        this.address = address;
        this.countOfMembers = countOfMembers;
        this.countOfTeams = countOfTeams;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.beginDate = dateFormat.format(beginDate);
        this.endDate = dateFormat.format(endDate);
        this.countOfStations = countOfStations;
        String label = "\u6b63\u5e38";
        Timestamp now = Timestamp.from(Instant.now());
        if (endDate.before(now)) {
            label = "\u5df2\u7ed3\u675f";
        } else if (beginDate.before(now)) {
            label = "\u672a\u5f00\u59cb";
        }
        this.statusLabel = label;
    }

    public static ProjectResponse create(Long pkId, String id, String name, String type, String principalName, String organizationId, String companyName, String address, int countOfMembers, int countOfTeams, Date beginDate, Date endDate, long countOfStations) {
        return new ProjectResponse(pkId, id, name, type, principalName, organizationId, companyName, address, countOfMembers, countOfTeams, beginDate, endDate, countOfStations);
    }

    public Long getPkId() {
        return this.pkId;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getStatusLabel() {
        return this.statusLabel;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getAddress() {
        return this.address;
    }

    public int getCountOfMembers() {
        return this.countOfMembers;
    }

    public int getCountOfTeams() {
        return this.countOfTeams;
    }

    public String getBeginDate() {
        return this.beginDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public long getCountOfStations() {
        return this.countOfStations;
    }
}

