/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructures.enums;

import java.util.Collection;
import java.util.HashSet;

public enum RepetitiveRule {
    Monday(1, "\u5468\u4e00"),
    Tuesday(2, "\u5468\u4e8c"),
    Wednesday(4, "\u5468\u4e09"),
    Thursday(8, "\u5468\u56db"),
    Friday(16, "\u5468\u4e94"),
    Saturday(32, "\u5468\u516d"),
    Sunday(64, "\u5468\u5929");

    String name;
    int value;

    private RepetitiveRule(int value, String name) {
        this.name = name;
        this.value = value;
    }

    public static int calculateRepetitiveRule(Collection<RepetitiveRule> rules) {
        int result = 0;
        for (RepetitiveRule rule : rules) {
            result |= rule.value;
        }
        return result;
    }

    public static Collection<RepetitiveRule> getSelectedRepetitiveRules(int repetitiveRule) {
        HashSet<RepetitiveRule> result = new HashSet<RepetitiveRule>();
        for (RepetitiveRule rule : RepetitiveRule.values()) {
            if ((rule.value & repetitiveRule) <= 0) continue;
            result.add(rule);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }
}

