package com.bcxin.backend.tasks.approval;

import com.bcxin.backend.domain.approval.services.BjApprovalDataPushService;
import com.bcxin.backend.tasks.TaskAbstract;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;

@Component
@ConditionalOnProperty(prefix = "myapps.bj-approval-data-push",name = "enable",havingValue = "true")
public class ApprovalDataPushWeeklyTask extends TaskAbstract {
    private final BjApprovalDataPushService approvalDataPushService;

    public ApprovalDataPushWeeklyTask(BjApprovalDataPushService approvalDataPushService) {
        this.approvalDataPushService = approvalDataPushService;
    }

    @Override
    protected void runCore() throws Exception {
        /**推送过去一周的审批数据。这里目的是补偿用
         */
        Date startDate = Date.from(Instant.now().minus(7, ChronoUnit.DAYS));
        logger.info("推送北京周审批数据开始:{}",new Date());
        this.approvalDataPushService.pushApprovalDataFromDate(startDate);
        logger.info("推送北京周审批数据结束:{}",new Date());
    }

    @Override
    public String getTaskName() {
        return "push.bj.approval.data.task.weekly";
    }
}
