package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.syncs.services.DataSyncQueueService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SyncFileViaFtpJobTask extends TaskAbstract {
    private final DataSyncQueueService dataSyncQueueService;

    public SyncFileViaFtpJobTask(
            @Qualifier("FtpDataSyncQueueServiceImpl") DataSyncQueueService dataSyncQueueService) {
        this.dataSyncQueueService = dataSyncQueueService;
    }

    @Override
    protected void runCore() {
        this.dataSyncQueueService.dispatchFile();
    }

    @Override
    public String getTaskName() {
        return "sync.file.ftp.data";
    }
}
