package com.bcxin.backend.pojo;

import lombok.Data;

/**
 * 办件过程信息参数(该传参为多个格式为list)
 */
@Data
public class UpProProcess {

    /**
     * 同步类型，I：新增件， U：修改件
     */
    String cdOperation;

    /**
     * 同步时间 yyyy-MM-dd HH:mm:ss now
     */
    String cdTime;

    /**
     * 数据来源 固定值：业务部门名称首字母_系统名称首字母，（‘_’隔开） 所属部门+系统名称的首字母
     */
    String dataSource;

    /**
     * 环节结束时间 yyyy-MM-dd HH:mm:ss
     */
    String eventEndTime;

    /**
     * 业务动作 1  通过2  退回9  其他
     */
    String eventName;

    /**
     * 环节开始时间 yyyy-MM-dd HH:mm:ss
     */
    String eventStartTime;

    /**
     * 办理意见 (备注) 无
     */
    String handleExplain;

    /**
     * 办理人姓名 民警名称
     */
    String handleUserName;


    /**
     * 记录唯一标识 本地id
     */
    String processId;


    /**
     * 办理环节名称
     * 预审、受理、审查、决定、办结等（如果不符合该环节名称，可以上传本系统环节名称）
     */
    String processName;

    /**
     * 办件编号  本地id
     */
    String projectNo;

    /**
     * 本环节是否需要评价 1 是， 0否
     */
    String isNeedService;


    /**
     * 记录标识(办件ID)  本地iD
     */
    String rowGuid;



}
