package com.bcxin.backend.certificateSignatures.impls;

import com.bcxin.backend.certificateSignatures.CertificateConfigProperty;
import com.bcxin.backend.certificateSignatures.CertificateSignatureProvider;
import com.bcxin.backend.domain.repositories.SignatureQueuesRepository;
import com.bcxin.backend.domain.services.impls.ConvertServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
@Qualifier("test")
public class CertificateSignatureProvider_Test extends CertificateSignatureProviderAbstract
        implements CertificateSignatureProvider {
    private static final Logger logger = LoggerFactory.getLogger(CertificateSignatureProvider_Test.class);

    public CertificateSignatureProvider_Test(CertificateConfigProperty configProperty,
                                             SignatureQueuesRepository signatureQueuesRepository,
                                             @Qualifier("primaryJdbcTemplate") JdbcTemplate jdbcTemplate,
                                             ConvertServiceImpl convertService) {
        super(configProperty, signatureQueuesRepository, jdbcTemplate, convertService);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
