/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.controller;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.jwt.JWT;
import cn.hutool.jwt.JWTPayload;
import cn.hutool.jwt.JWTUtil;
import com.bcxin.backend.dto.Result;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/document/signature"})
public class DocumentSignatureController {
    private static final Logger log = LoggerFactory.getLogger(DocumentSignatureController.class);
    @Value(value="${myapps.addin.exe}")
    String exepath;
    @Value(value="${myapps.this.ip}")
    String thisIp;
    @Value(value="${server.port}")
    String port;
    @Value(value="${myapps.domain.url}")
    String url;
    @Value(value="${myapps.storage.root}")
    String rootPath;
    @Autowired
    private Environment env;
    private static String jwtKey = "sdoDFyzfieqMrisd0H5o5t9weOl6GmSr";

    @RequestMapping(value={"/multBrowser"})
    public String multBrowser(HttpServletRequest request, Model model) throws URISyntaxException {
        String path = request.getParameter("documentPath");
        String business_no = request.getParameter("business_no");
        String business_user_id = request.getParameter("business_user_id");
        String use_seal_explain = request.getParameter("use_seal_explain");
        if (StringUtils.isEmpty((CharSequence)path) || StringUtils.isEmpty((CharSequence)business_no) || StringUtils.isEmpty((CharSequence)business_user_id)) {
            throw new RuntimeException("\u5fc5\u8981\u53c2\u6570\u7f3a\u5931\uff01");
        }
        path = this.url.startsWith("http") ? path : this.url + path;
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("path", path);
        payload.put("business_no", business_no);
        payload.put("business_user_id", business_user_id);
        payload.put("use_seal_explain", use_seal_explain);
        String api = "http://" + this.thisIp + ":" + this.port + "/document/signature/iWebPDFEditor/" + JWTUtil.createToken(payload, (byte[])jwtKey.getBytes());
        model.addAttribute("exepath", (Object)this.exepath);
        model.addAttribute("apiHead", (Object)api);
        return "multBrowser";
    }

    @RequestMapping(value={"/iWebPDFEditor/{token}"})
    public String iWebPDFEditor(@PathVariable String token, HttpServletRequest request, Model model) {
        JWT jwt = JWTUtil.parseToken((String)token);
        JWTPayload ipayload = jwt.getPayload();
        String path = (String)ipayload.getClaimsJson().get((Object)"path", String.class);
        String business_no = (String)ipayload.getClaimsJson().get((Object)"business_no", String.class);
        String business_user_id = (String)ipayload.getClaimsJson().get((Object)"business_user_id", String.class);
        String use_seal_explain = (String)ipayload.getClaimsJson().get((Object)"use_seal_explain", String.class);
        boolean verify = jwt.setKey(jwtKey.getBytes()).verify();
        if (!verify) {
            throw new RuntimeException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        boolean validate = jwt.validate(0L);
        if (!validate) {
            throw new RuntimeException("token\u8fc7\u671f\uff01");
        }
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("path", path);
        String oidPath = this.rootPath + path.replace(this.url, "");
        File f = new File(oidPath);
        if (!f.exists()) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        String name = f.getName();
        String type = FileUtil.getSuffix((File)f);
        String newName = IdUtil.randomUUID() + "." + type;
        String newPath = oidPath.replace(name, newName);
        FileUtil.copy((String)oidPath, (String)newPath, (boolean)true);
        model.addAttribute("path", (Object)path.replace(name, newName));
        String uploadApi = "http://" + this.thisIp + ":" + this.port + "/document/signature/uploadBase64/" + JWTUtil.createToken(payload, (byte[])jwtKey.getBytes());
        model.addAttribute("apiHead", (Object)uploadApi);
        model.addAttribute("business_no", (Object)business_no);
        model.addAttribute("business_user_id", (Object)business_user_id);
        model.addAttribute("use_seal_explain", (Object)use_seal_explain);
        return "iWebPDFEditor";
    }

    @RequestMapping(value={"/uploadBase64/{token}"})
    @ResponseBody
    public Result uploadBase64(@PathVariable String token, HttpServletRequest request) {
        JWT jwt = JWTUtil.parseToken((String)token);
        JWTPayload payload = jwt.getPayload();
        String path = (String)payload.getClaimsJson().get((Object)"path", String.class);
        String serverPath = this.rootPath + path.replace(this.url, "");
        boolean verify = jwt.setKey(jwtKey.getBytes()).verify();
        if (!verify) {
            return Result.fail((String)"\u53c2\u6570\u5f02\u5e38");
        }
        boolean validate = jwt.validate(0L);
        if (!validate) {
            return Result.fail((String)"token\u8fc7\u671f");
        }
        System.out.println(serverPath);
        File f = new File(serverPath);
        if (!f.exists()) {
            f.mkdirs();
        }
        try (ServletInputStream in = request.getInputStream();
             FileOutputStream fos = new FileOutputStream(f);){
            byte[] b = new byte[1024];
            int n = 0;
            while ((n = in.read(b)) != -1) {
                fos.write(b, 0, n);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Result.success((String)"ok");
    }

    public static void main(String[] args) {
    }
}

