/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.approval.services.impl;

import com.bcxin.backend.core.utils.RetryUtil;
import com.bcxin.backend.domain.approval.entities.dest.BjGaServiceStatisticOdsEntity;
import com.bcxin.backend.domain.approval.entities.source.BjApprovalDataEntity;
import com.bcxin.backend.domain.approval.repositories.dest.BjGaServiceStatisticOdsRepository;
import com.bcxin.backend.domain.approval.repositories.source.BjApprovalDataRepository;
import com.bcxin.backend.domain.approval.services.BjApprovalDataPushService;
import com.bcxin.backend.domain.approval.utils.DataTransformUtil;
import io.jsonwebtoken.lang.Collections;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="myapps.bj-approval-data-push", name={"enable"}, havingValue="true")
public class BjApprovalDataPushServiceImpl
implements BjApprovalDataPushService {
    private static final Logger log = LoggerFactory.getLogger(BjApprovalDataPushServiceImpl.class);
    private BjApprovalDataRepository approvalDataRepository;
    private BjGaServiceStatisticOdsRepository gaServiceStatisticOdsRepository;

    public BjApprovalDataPushServiceImpl(BjApprovalDataRepository approvalDataRepository, BjGaServiceStatisticOdsRepository gaServiceStatisticOdsRepository) {
        this.approvalDataRepository = approvalDataRepository;
        this.gaServiceStatisticOdsRepository = gaServiceStatisticOdsRepository;
    }

    @Override
    public void pushApprovalDataFromDate(Date startDate) {
        try {
            RetryUtil.execute(() -> {
                Collection<BjApprovalDataEntity> approvalDataEntities = this.approvalDataRepository.findFromDate(startDate);
                Collection<BjGaServiceStatisticOdsEntity> bjGaServiceStatisticOdsEntities = DataTransformUtil.trans2BjGaServiceStatisticOdsEntity(approvalDataEntities);
                this.pushData(bjGaServiceStatisticOdsEntities);
                return true;
            }, (int)3);
            log.info("\u65e5\u671f\uff1a{}\uff0c\u63a8\u9001\u5ba1\u6279\u6570\u636e\u6210\u529f\uff01", (Object)startDate);
        }
        catch (Exception e) {
            log.error("\u65e5\u671f\uff1a{}\uff0c\u63a8\u9001\u5ba1\u6279\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)startDate, (Object)e);
            throw e;
        }
    }

    @Override
    public void pushApprovalDataInit(Date startDate) {
        try {
            Collection<BjApprovalDataEntity> approvalDataEntities = this.approvalDataRepository.findCreatedFromDate(startDate);
            Collection<BjGaServiceStatisticOdsEntity> bjGaServiceStatisticOdsEntities = DataTransformUtil.trans2BjGaServiceStatisticOdsEntity(approvalDataEntities);
            this.pushData(bjGaServiceStatisticOdsEntities);
            log.info("\u65e5\u671f\uff1a{}\uff0c\u521d\u59cb\u5316\u63a8\u9001\u5ba1\u6279\u6570\u636e\u6210\u529f\uff01", (Object)startDate);
        }
        catch (Exception e) {
            log.info("\u65e5\u671f\uff1a{}\uff0c\u521d\u59cb\u5316\u63a8\u9001\u5ba1\u6279\u6570\u636e\u5f02\u5e38\uff1a{}\uff01", (Throwable)e);
        }
    }

    @Override
    public void pushData(Collection<BjGaServiceStatisticOdsEntity> bjGaServiceStatisticOdsEntities) {
        if (!Collections.isEmpty(bjGaServiceStatisticOdsEntities)) {
            this.gaServiceStatisticOdsRepository.saveAll(bjGaServiceStatisticOdsEntities);
        }
    }
}

