package com.bcxin.signature.util.ftp;


import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * <b> 批量上传 </b>
 * @author ZXF
 * @create 2023/07/07 0007 13:43
 * @version
 * @注意事项 </b>
 */
public class FtpWriteUtil {


    /**
     * <b> 将base64字符流写入指定文件 </b>
     * @author ZXF
     * @create 2024/11/27 0027 8:46
     * @version
     * @注意事项 </b>
     */
    public static boolean uploadBase64(String ftpPath, String ftpFileName, String base64Content) {
        boolean result = false;
        FtpWriteConnection ftp = new FtpWriteConnection();//获取ftp con
        try {
            //创建n个ftp链接
//            FtpWriteFactory factory = new FtpWriteFactory();//连接FTP
//            FtpWriteConnection ftp = factory.getFtp();//获取ftp con
            result = ftp.uploadBase64(ftpPath, ftpFileName, base64Content);

        } catch (IOException e) {
            System.err.println("=======>上传base64文件失败ftp异常："+e.getMessage()+"<=======");
        }finally {
            try {
                ftp.disconnect();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /**
     * <b> 获取ftp目录下所有最近5分钟内生成的文件的文件名，返回文件名列表 </b>
     * @author ZXF
     * @create 2024/11/27 0027 8:44
     * @version
     * @注意事项 </b>
     */
    public static List<String> filenames(String path,String keywork) {
        try {
            //创建n个ftp链接
            FtpWriteFactory factory = new FtpWriteFactory();//连接FTP
            FtpWriteConnection ftp = factory.getFtp();//获取ftp con
            return ftp.fileNames(path,keywork);
        } catch (IOException e) {
            System.err.println("=======>获取ftp目录下所有最近5分钟内生成的文件的文件名："+e.getMessage()+"<=======");
        }
        return new ArrayList<>();
    }

}
