/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.api.controller;

import cn.hutool.core.date.DateUtil;
import com.bcxin.signature.config.exception.BusinessException;
import com.bcxin.signature.config.yesign.YesignUtil;
import com.bcxin.signature.util.StringUtils;
import com.bcxin.signature.util.common.cipher.MD5Util;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/signature/api/file"})
public class FileController {
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    @Autowired
    private YesignUtil yesignUtil;
    @Value(value="${signature.api}")
    String api;

    @PostMapping(value={"/yesign"})
    public void yesign(MultipartHttpServletRequest request, HttpServletResponse response) {
        String token = request.getParameter("token");
        MultipartFile signpdf = request.getFile("signpdf");
        String fileName = request.getParameter("fileName");
        if (StringUtils.isEmpty((CharSequence)fileName) || signpdf == null) {
            throw new BusinessException("300", "\u53c2\u6570\u5f02\u5e38\uff01");
        }
        String cretoken = MD5Util.string2MD5((String)("BCXIN" + fileName + DateUtil.today()));
        if (StringUtils.isEmpty((CharSequence)token) || !token.equals(cretoken)) {
            throw new BusinessException("403", "\u975e\u6cd5\u8bf7\u6c42\uff0c\u6765\u6e90\u4e0d\u53d7\u4fe1\u4efb\uff01");
        }
        try {
            this.yesignUtil.signPdf(signpdf, this.api, fileName, response);
        }
        catch (Exception e) {
            throw new BusinessException("500", "\u7b7e\u7ae0\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

