package com.bcxin.backend.domain.configs;

import java.util.concurrent.atomic.AtomicInteger;

public class SyncLimiter {
    // 限流的个数
    private int maxCount = 1000;
    // 指定的时间内(默认1s）
    private long interval = 1;
    // 原子类计数器
    private AtomicInteger atomicInteger = new AtomicInteger(0);
    // 起始时间
    private long startTime = System.currentTimeMillis();

    public boolean get() {
        if (atomicInteger.get() == 0) {
            startTime = System.currentTimeMillis();
            return true;
        }
        // 超过了间隔时间，直接重新开始计数
        if (System.currentTimeMillis() - startTime > interval * 1000) {
            startTime = System.currentTimeMillis();
            atomicInteger.set(1);
            return true;
        }
        // 还在间隔时间内,check有没有超过限流的个数
        if (atomicInteger.get() > maxCount) {
            return false;
        }
        return true;
    }

    public void set() {
        atomicInteger.addAndGet(1);
    }

    public int getMaxCount() {
        return atomicInteger.get();
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public void setInterval(int interval){
        this.interval = interval;
    }
}
