/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.syncs.listeners;

import com.bcxin.backend.domain.syncs.events.SyncDataApplicationEvent;
import com.bcxin.backend.domain.syncs.services.DataSyncQueueService;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class SyncDataEventListener
implements ApplicationListener<SyncDataApplicationEvent> {
    private final Collection<DataSyncQueueService> dataSyncQueueServices;
    private static final Logger logger = LoggerFactory.getLogger(SyncDataEventListener.class);

    public SyncDataEventListener(ApplicationContext applicationContext) {
        this.dataSyncQueueServices = applicationContext.getBeansOfType(DataSyncQueueService.class).values();
    }

    @Async
    public void onApplicationEvent(SyncDataApplicationEvent event) {
        this.dataSyncQueueServices.parallelStream().forEach(dataSyncQueueService -> {
            try {
                dataSyncQueueService.dispatchData();
            }
            catch (Exception ex) {
                logger.error(String.format("\u540c\u6b65\u6570\u636e(%s)\u6267\u884c\u5f02\u5e38", dataSyncQueueService.getClass().getName()), (Throwable)ex);
            }
            try {
                dataSyncQueueService.dispatchFile();
            }
            catch (Exception ex) {
                logger.error(String.format("\u540c\u6b65\u6587\u4ef6(%s)\u6267\u884c\u5f02\u5e38", dataSyncQueueService.getClass().getName()), (Throwable)ex);
            }
        });
    }
}

