/*
 * Decompiled with CFR 0.152.
 */
package com.oppo.push.server;

import java.io.File;
import java.util.regex.Pattern;

class Validate {
    private static final Pattern PATTERN_OBJECT_ID = Pattern.compile("[0-9a-fA-F]{24}");
    private static final Pattern PATTERN_REGISTRATION_ID = Pattern.compile("((([0-9A-Za-z]{2,10})_)?([A-Z]{2}|EUEX)_)?[0-9a-fA-F]{32}");
    private static final Pattern PATTERN_ERROR_CODE = Pattern.compile("[0-9]+");
    private static final Pattern FILE_SUFFIX_IMAGE = Pattern.compile("[^*]+\\.(JPEG|JPG|PNG|)$");

    Validate() {
    }

    static <T> T nonNull(T source, String field) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("%s%s", field, " cannot be null"));
        }
        return source;
    }

    static Integer validatePositiveInteger(Integer value, String field) {
        if (value == null || value < 0) {
            throw new IllegalArgumentException(String.format("%s%s", field, " must be positive "));
        }
        return value;
    }

    static void validateLength(String source, String field, int limit) {
        if (source.length() > limit) {
            throw new IllegalArgumentException(String.format("%s%s%s", field, " length limit is ", limit));
        }
    }

    static void validateSize(int value, String field, int limit) {
        if (value < 0 || value > limit) {
            throw new IllegalArgumentException(String.format("%s%s", field, " value is invalid"));
        }
    }

    static boolean isEmpty(CharSequence source) {
        return source == null || source.length() == 0;
    }

    static boolean validateRegistrationId(String registrationId) {
        return !Validate.isEmpty(registrationId) && (PATTERN_REGISTRATION_ID.matcher(registrationId).matches() || PATTERN_OBJECT_ID.matcher(registrationId).matches());
    }

    static boolean validateErrorCode(String errorCode) {
        return !Validate.isEmpty(errorCode) && PATTERN_ERROR_CODE.matcher(errorCode).matches();
    }

    static void validatePictureType(File file) {
        if (file == null || !FILE_SUFFIX_IMAGE.matcher(file.getName().toUpperCase()).matches()) {
            throw new IllegalArgumentException("picture format must be PNG/JPEG/JPG");
        }
    }

    static void validateFileMaxSize(File file, long maxSize) {
        if (file == null || file.length() > maxSize) {
            throw new IllegalArgumentException(String.format("%s%s%s", " file Size limit is", maxSize / 1204L, "KB"));
        }
    }

    static void validateStyle(Integer style) {
        if (style < 1 || style > 3) {
            throw new IllegalArgumentException(String.format("%s%s", " notification style can not choose ", style));
        }
    }
}

