/*
 * Decompiled with CFR 0.152.
 */
package com.oppo.push.server;

import com.alibaba.fastjson.JSON;
import com.oppo.push.server.Constants;
import com.oppo.push.server.HttpClientTool;
import com.oppo.push.server.RequestPath;
import com.oppo.push.server.Result;
import com.oppo.push.server.Validate;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

class Auth {
    private static final String SHA_256 = "SHA-256";

    Auth() {
    }

    static Result getAuthResult(String appKey, String masterSecret) throws Exception {
        HashMap<String, Object> body = new HashMap<String, Object>(3);
        long timestamp = System.currentTimeMillis();
        body.put("app_key", appKey);
        body.put("timestamp", timestamp);
        body.put("sign", Auth.getSign(appKey, timestamp, masterSecret));
        return Auth.getAuthResultWithRetry(RequestPath.AUTH, body);
    }

    private static Result getAuthResultWithRetry(RequestPath path, Map<String, Object> body) throws Exception {
        Result result = null;
        int tryTime = 0;
        while (tryTime < Constants.HTTP_RETRY_TIME) {
            try {
                result = HttpClientTool.httpPost(path, body);
                if (result != null && !Validate.isEmpty(result.getToken())) {
                    return result;
                }
                ++tryTime;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (tryTime >= Constants.HTTP_RETRY_TIME - 1) {
                    throw e;
                }
                ++tryTime;
            }
        }
        throw new RuntimeException(String.format("get token error: %s", result == null ? "get token result is null" : JSON.toJSONString((Object)result)));
    }

    private static String getSign(String appKey, long timestamp, String masterSecret) throws Exception {
        String plaintext = String.format("%s%s%s", appKey, timestamp, masterSecret);
        return Auth.encrypt(plaintext, SHA_256);
    }

    private static String encrypt(String plaintext, String encryptType) throws Exception {
        String cipherText = null;
        if (plaintext != null && plaintext.length() > 0) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(encryptType);
                messageDigest.update(plaintext.getBytes());
                byte[] byteBuffer = messageDigest.digest();
                StringBuilder strHexString = new StringBuilder(byteBuffer.length * 2);
                for (int i = 0; i < byteBuffer.length; ++i) {
                    String hex = Integer.toHexString(0xFF & byteBuffer[i]);
                    if (hex.length() == 1) {
                        strHexString.append('0');
                    }
                    strHexString.append(hex);
                }
                cipherText = strHexString.toString();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                throw e;
            }
        }
        return cipherText;
    }
}

