/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.hibernateplus.utils;

import com.bcxin.risk.hibernateplus.utils.TypeConvert;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtils {
    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static int getRandomInt(int max) {
        return RandomUtils.getRandom().nextInt(max);
    }

    public static int getRandomInt(int min, int max) {
        return RandomUtils.getRandom().nextInt(max - min + 1) + min;
    }

    public static long getRandomLong(long max) {
        return RandomUtils.getRandom().nextLong(max);
    }

    public static <E> E getRandomElement(E[] array) {
        return array[RandomUtils.getRandomInt(array.length)];
    }

    public static <E> E getRandomElement(List<E> list) {
        return list.get(RandomUtils.getRandomInt(list.size()));
    }

    public static <E> E getRandomElement(Set<E> set) {
        int randomInt = RandomUtils.getRandomInt(set.size());
        int i = 0;
        for (E e : set) {
            if (i == randomInt) {
                return e;
            }
            ++i;
        }
        return null;
    }

    public static <K, V> K getMapRandomKey(Map<K, V> map) {
        int randomInt = RandomUtils.getRandomInt(map.size());
        int i = 0;
        for (K key : map.keySet()) {
            if (i == randomInt) {
                return key;
            }
            ++i;
        }
        return null;
    }

    public static <K, V> V getMapRandomValue(Map<K, V> map) {
        int randomInt = RandomUtils.getRandomInt(map.size());
        int i = 0;
        for (V value : map.values()) {
            if (i == randomInt) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public static String getRandNumber(int n) {
        String random = "";
        if (n > 0 && n < 10) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                builder.append('9');
            }
            int num = TypeConvert.toInt(builder.toString());
            while (random.length() < n) {
                random = TypeConvert.toString(ThreadLocalRandom.current().nextInt(num));
            }
        } else {
            random = "0";
        }
        return random;
    }
}

