import React, { Component } from "react";
import RreactDom from 'react-dom';
import { message } from 'antd';
// import PropTypes from 'prop-types';
import PersonModal from '../../components/user/PersonModal';
// 弹窗组件
class ModalContainer extends Component {
  constructor(props, context) {
    super(props, context);

    this.state = {
      visible: true
    };
  }
  render() {
    const close = () => {
      this.setState({
        visible: false
      }, () => {
        // 删除组件
        setTimeout(() => {
          const divs = document.getElementsByClassName('per_modal');
          Reflect.apply(Array.prototype.forEach, divs, [item => {
            RreactDom.unmountComponentAtNode(item);
            document.body.removeChild(item);
          }]);
        },300);
      });
    }
    return (
      <PersonModal
        visible={this.state.visible}
        {...this.props}
        onOk={value => {
          if(this.props.onOk) {
            if(value.length == 0) {
              message.warning('请选择人员');
            }else {
              this.props.onOk(value, close);
            }
          }else {
            close();
          }
        }}
        onCancel={value => {
          if(this.props.onCancel) {
            this.props.onCancel(value, close);
          }else {
            close();
          }
        }}
      />
    );
  }
}

// NormalModal.propTypes = {

// };

// 插入弹窗
export default function showInsuranceModal(props) {
  const div = document.createElement('div');
  div.setAttribute('class', 'per_modal');
  document.body.appendChild(div);
  RreactDom.render(<ModalContainer {...props} />, div);
}