
/* *
*@params personApplyId
*@params setParentState
 */
import React, { Component } from 'react';
import { connect } from 'dva';
import st from 'styled-components';
import moment from 'moment';
import { Button, Drawer, Form, Input, Row, Col, Select, Modal, notification, message, Radio } from 'antd';
import PSelect from '../../../../components/Pro/PSelect';
import {
  // enterpriseComContractGetComContractById,
  systemPerCerBaseInfoFind, publicCommonFileFilePreview, getBayBaseInfo
} from '../../../../services/api';
import PFromUpload from '../../../../components/Pro/PFromUpload';
import SelectContactByPerId from '../../../../components/contranct/SelectContactByPerId';
// import BTable from '../../../../components/Pro/BTable';
import InternshipRecord from './InternshipRecord';
import { $getFormItems } from '../../../PoliceDeclare/GradeCertificate/AddCertificate/ImageFormItem';
import BTable from '../../../../components/Pro/BTable';
import $modal from '../../../../utils/modal';
import $nModal from '../../../../utils/modal/nModal';
import {
  trainGradeApplyMaterialApproveReject,
  trainGradeApplyDealMaterialApprove,
  trainGradeApplyInfoModifyLog,
  trainGradeApplyInfo,
  trainGradeApplyPersonApplyUpdate,
  grade_ApplyPersonApplyCompareUpdate,
} from '../../../../services/bkt/apis';
import PTable from '../../../../components/Pro/PTable';
const { TextArea } = Input;
const { Option } = Select;
const formItemLayout = {
  labelCol: {
    xs: {
      span: 24
    },
    sm: {
      span: 7
    }
  },
  wrapperCol: {
    xs: {
      span: 24
    },
    sm: {
      span: 20
    },
    md: {
      span: 16
    }
  }
};
const formItemLayout1 = {
  labelCol: {
    span: 24
  },
  wrapperCol: {
    span: 24
  }
};
@connect(state => ({
  companyInfo: state.global.companyInfo
}))
@Form.create()
export default class SubDrawer extends Component {
  constructor(props) {
    super(props);
    this.state = {
      oldPersonApplyId: '',
      comName: this.props.companyInfo.comName,
      info: null,  //申报详情
      // contracInfo: {},  //合同详情
      certInfo: {}, //证书详情
      imgs: [],
      recordShow: false, //实习记录的显示
      refuseModal: false,  //拒绝的弹窗
      refuseReason: '',  //拒绝原因

      isEdit: false, //是否处于材料编辑状态
      isComparisonEdit: false, //是否处于比对编辑状态

      editUser: null,  //当前操作人信息
      editList: [],  //修改记录

      comContractInfo: null, //修改合同选中的合同信息
      contractModal: false, //合同弹窗
    };
  }
  componentWillMount() {
    // this.__getDistrict();
  }
  componentDidMount() { }
  componentWillReceiveProps(nextProps) {
    if (!!nextProps.personApplyId && this.state.oldPersonApplyId != nextProps.personApplyId) {
      this.setState({ oldPersonApplyId: nextProps.personApplyId });
      this._getDetailInfo(nextProps.personApplyId);
      // 重置合同信息和修改记录
      this.setState({
        editList: [],
        comContractInfo: null
      });
    }
  }

  _getDetailInfo = (personApplyId) => {
    trainGradeApplyInfo({ data: { personApplyId } }).then(res => {
      this.setState({
        info: res.data,
        isEdit: false, isComparisonEdit: false
      });
      if (res.data) {
        const {
          // comContractId, 
          perCerId, retireUrl } = res.data;
        // 获取合同信息
        // if (!!comContractId) {
        //   enterpriseComContractGetComContractById({ comContractId }).then(result => {
        //     if (result.data) {
        //       this.setState({
        //         contracInfo: result.data
        //       });
        //     }
        //   });
        // }
        // 获取证书信息
        if (!!perCerId) {
          systemPerCerBaseInfoFind({ perCerId }).then(certRes => {
            if (certRes.data) {
              this.setState({
                certInfo: certRes.data
              });
            }
          });
        }
        // 重组图像文件
        // const imgArr = $getFormItems(personType);
        // const avatar = {
        //   label: '两寸蓝底彩照',
        //   fieldsName: 'avatar',
        //   types: ['image/jpeg', 'image/jpg'],
        //   size: 75 / 1024,
        //   sizeErrMsg: "仅限上传文件小于75kb的jpg文件",
        //   rules: [{
        //     required: true,
        //     message: `两寸蓝底彩照`
        //   }]
        // };
        // imgArr.unshift(avatar);
        const imgArr = [{
          label: '两寸蓝底彩照',
          fieldsName: 'avatar',
          types: ['image/jpeg', 'image/jpg'],
          size: 75 / 1024,
          sizeErrMsg: "仅限上传文件小于75kb的jpg文件",
          rules: [{
            required: true,
            message: `两寸蓝底彩照`
          }]
        }, {
          label: '身份证人像面',
          fieldsName: 'idCardNoFrontUrl',
          rules: [{
            required: true,
            message: `请上传身份证人像面`
          }]
        }, {
          label: '身份证国徽面',
          fieldsName: 'idCardNoBackUrl',
          rules: [{
            required: true,
            message: `请上传身份证国徽面`
          }]
        }]
        if(retireUrl){
          imgArr.push({
            label: '《退役证》或《复员证》或《转业证》',
            fieldsName: 'retireUrl',
            rules: [{
              required: true,
              message: `请上传《退役证》或《复员证》或《转业证》`
            }]
          })
        }
        const rows = [];
        const length = Math.ceil(imgArr.length / 3);
        for (let i = 0; i < length; i++) {
          rows.push([
            imgArr[i * 3],
            imgArr[i * 3 + 1],
            imgArr[i * 3 + 2]
          ]);
        }
        this.setState({
          imgs: rows
        });
      }
    });
  }

  _onSubmit = () => {
    const { isEdit, isComparisonEdit } = this.state;
    this.props.form.validateFields((err, values) => {
      console.log(values);
      if (!err) {
        this._getUserInfo(() => {
          const materialApprovePerName = this.state.editUser.name;
          const materialApprovePerIdCardNo = this.state.editUser.idCardNo;
          const { personType } = this.state.info;
          const { personApplyId } = this.props;
          // 材料核对编辑
          if (isEdit) {
            const { comContractInfo } = this.state;
            const comContractId = comContractInfo ? comContractInfo.comContractId : this.state.info.comContractId;
            if (!comContractId) {
              return $modal(res.msg, '');
            }
            const data = { ...values, materialApprovePerName, materialApprovePerIdCardNo, personType, personApplyId, comContractId };
            trainGradeApplyPersonApplyUpdate({ data }).then(res => {
              $modal(res.msg, '', null, 'success');
              this._getDetailInfo(personApplyId);
            });
          } else if (isComparisonEdit) {//补贴核对编辑
            grade_ApplyPersonApplyCompareUpdate({
              data: {
                personApplyId,
                residentType: values.residentType,
                residentPlaceType: values.residentPlaceType,
                gradeCertNo: values.gradeCertNo,
                materialApprovePerName,
                materialApprovePerIdCardNo
              }
            }).then(res => {
              $modal(res.msg, '', null, 'success');
              this._getDetailInfo(personApplyId);
              // 更新列表
              this.props.setParentState({
                forceUpdate: true
              }, () => {
                this.props.setParentState({
                  forceUpdate: false
                });
              });
            });
          }
        });
      }
    });
  }
  // 获取操作人信息
  _getUserInfo = (cb) => {
    if (this.state.editUser) {
      cb();
    } else {
      getBayBaseInfo().then(res => {
        this.setState({
          editUser: res.data
        }, cb);
      })
    }
  }
  //不合格原因弹窗
  unqualifiedModal = () => {
    Modal.info({
      title: '不合格原因',
      width: 700,
      content: (
        <div>
          {
            this.state.info.checkFailContent ?
              this.state.info.checkFailContent.map(item => {
                return (
                  <div style={{ display: "flex" }}>
                    <p style={{ whiteSpace: "nowrap", marginRight: "5px" }}>{item.date} | </p>
                    <p>{item.content}</p>
                  </div>
                )
              }) : ""
          }
          <div>
            <p>备注：</p>
            <p>（1）学员基本信息不合格需由培训学校通过编辑学员报名信息进行修改更新；</p>
            <p>（2）学习记录不合格需要通知学员登录App重新学习对应的章节课程；</p>
            <p>（3）学习记录不合格需要通知学员登录App重新实习签到：如不合格记录有2条，则需要重新签到2天；</p>
          </div>
        </div>
      ),
      onOk() { },
    });
  }

  render() {
    const { getFieldDecorator } = this.props.form;
    const { info, certInfo, isEdit, isComparisonEdit, comContractInfo } = this.state;
    return (
      <div>
        <Drawer
          title="报名详情"
          width={600}
          visible={!!this.props.personApplyId}
          destroyOnClose={true}
          // visible={true}
          onClose={() => {
            this.props.setParentState({
              personApplyId: ''
            });
            this.setState({
              isEdit: false,
              isComparisonEdit: false
            });
          }}
        >
          {/* form表单 */}
          {
            info &&
            <div>
              <section style={{ display: isEdit || isComparisonEdit ? 'none' : 'block', marginBottom: 15 }}>
                <Button
                  type="primary"
                  disabled={info.applyStatus == '3'} // 已撤销的不能操作
                  style={{ marginRight: 8 }}
                  onClick={() => this.setState({ isEdit: true })}
                >
                  编辑学员报名信息
                </Button>
                {
                  // 报名比对状态compareStatus 补贴比对状态bonusCompareStatus 为可修改的时候
                  (info.bonusCompareStatus == '3' || info.compareStatus == '3') &&
                  <Button
                    type="primary"
                    disabled={info.applyStatus == '3'} // 已撤销的不能操作
                    style={{ marginRight: 8 }}
                    onClick={() => this.setState({ isComparisonEdit: true })}
                  >
                    编辑比对信息
                  </Button>
                }
                <Button
                  type="primary"
                  style={{ marginRight: 8 }}
                  onClick={() => {
                    const { personApplyId } = this.props;
                    const columns = [
                      {
                        title: '时间',
                        dataIndex: 'creationDate',
                        key: 'creationDate',
                      },
                      {
                        title: '操作人姓名',
                        dataIndex: 'modifyName',
                        key: 'modifyName',
                      },
                      {
                        title: '操作人身份证号',
                        dataIndex: 'modifyIdCardNo',
                        key: 'modifyIdCardNo',
                      },
                      {
                        title: '操作记录(点击蓝色文字可查看文件)',
                        dataIndex: 'number',
                        key: 'number',
                        render: (text, record) => {
                          let { content, newValue, oldValue } = record;
                          content = content.replace(/\[旧内容\]/, `<a style="marginRight: 10px;" href="${oldValue}" target="_blank">[旧内容]</a>`);
                          content = content.replace(/\[新内容\]/, `<a style="marginRight: 10px;"  href="${newValue}" target="_blank">[新内容]</a>`);
                          return (
                            <div style={{ maxWidth: 200 }}>
                              <p dangerouslySetInnerHTML={{ __html: content }}></p>
                              {/* <p>
                                {
                                oldValue && oldValue.indexOf('http') >= 0 &&
                                <a style={{marginRight: 10}}  href={oldValue} target="_blank">查看旧值</a>
                              }
                              {
                                newValue && newValue.indexOf('http') >= 0 &&
                                <a style={{marginRight: 10}} href={newValue} target="_blank">查看新值</a>
                              }
                              </p> */}
                            </div>
                          )
                        }
                      },
                    ];
                    const editParms = {
                      personApplyId,
                      pageNumber: 1,  // 页	
                      pageSize: 10  //条目
                    };
                    $nModal({
                      title: "修改记录",
                      footer: null,
                      width: 800,
                      content: (
                        <BTable
                          style={{ marginTop: 10 }}
                          columns={columns}
                          url="trainGradeApplyInfoModifyLog"
                          pageParm={editParms}
                          // pageParm={this.state.editParms}
                          dateChange={(e) => { }}
                        />
                        // <TableContainer>
                        //   <Table
                        // columns={}
                        //     dataSource={this.state.editList}
                        //     // url="trainGradeApplyInfoModifyLog"
                        //   />
                        // </TableContainer>
                      )
                    });

                  }}
                >
                  修改记录
                </Button>
              </section>
              {
                info.materialApproveStatus == '2' &&
                <p style={{ color: '#D9001B', marginLeft: 21 }}>材料核对不通过原因: {info.materialApproveFailReason}</p>
              }
              {
                info.approveStatus == '2' &&
                <p style={{ color: '#D9001B', marginLeft: 21 }}>审核不通过原因: {info.approveFailReason}</p>
              }
              <Form onSubmit={this._onSubmit} style={{ marginBottom: '50px' }} layout="horizontal">
                <Form.Item {...formItemLayout} label="材料审核状态">
                  {getFieldDecorator('materialApproveStatus', {
                    initialValue: info.materialApproveStatus || '0'
                  })(<Select disabled style={{ minWidth: 150 }} >
                    <Option value="0">未核对</Option>
                    <Option value="1">核对通过</Option>
                    <Option value="2">核对不通过</Option>
                  </Select>)}
                </Form.Item>
                {
                  info.checkStatus == "0" || info.checkStatus == null ? "" :
                    <Form.Item {...formItemLayout} label="协会抽查结果">
                      {
                        info.checkStatus == "1" ?
                          <div>
                            <span>合格</span>
                          </div> :
                          <div>
                            <span>不合格</span>
                            <Button type="link" onClick={this.unqualifiedModal}>查看不合格原因</Button>
                          </div>
                      }
                    </Form.Item>
                }
                <Form.Item {...formItemLayout} label="姓名">
                  {getFieldDecorator('fullname', {
                    initialValue: info.fullname
                  })(<Input placeholder="" maxLength={30} disabled={true} />)}
                </Form.Item>

                <Form.Item {...formItemLayout} label="身份证号">
                  {getFieldDecorator('identitynumber', {
                    initialValue: info.identitynumber
                  })(<Input placeholder="" maxLength={30} disabled={true} />)}
                </Form.Item>
                {
                  info.isMakeUp == '1' && <Form.Item {...formItemLayout} label="是否补考">
                    {getFieldDecorator('isMakeUp', {
                      initialValue: info.isMakeUp || '0'
                    })(<Select disabled style={{ minWidth: 150 }} >
                      <Option value="0">否</Option>
                      <Option value="1">是</Option>
                    </Select>)}
                  </Form.Item>
                }

                {
                  //审核不通过的时候，显示费用缴交状态
                  info.materialApproveStatus == '2' &&
                  <Form.Item {...formItemLayout} label="补考费缴交状态">
                    {getFieldDecorator('isMakeUpPay', {
                      initialValue: info.isMakeUpPay
                    })(<Select disabled style={{ minWidth: 150 }} >
                      <Option value="0">未缴费</Option>
                      <Option value="1">已缴费</Option>
                    </Select>)}
                  </Form.Item>
                }
                {
                  (() => {
                    let isDisabled = true;

                    // 编辑信息的时候如果是材料核对通过不让修改
                    if (isEdit) {
                      if (info.materialApproveStatus == '1') {
                        isDisabled = true;
                      } else {
                        isDisabled = false;
                      }
                    } else {
                      isDisabled = true
                    }
                    // 编辑比对信息的情况
                    if (isComparisonEdit) {
                      isDisabled = false;
                    }
                    return (
                      <>
                        <Form.Item {...formItemLayout} label="户籍类型">
                          {getFieldDecorator('residentType', {
                            initialValue: info.residentType
                          })(<PSelect disabled={isDisabled} style={{ width: '100%' }} type="residentType" />)}
                        </Form.Item>
                        <Form.Item {...formItemLayout} label="户籍所在地">
                          {getFieldDecorator('residentPlaceType', {
                            initialValue: info.residentPlaceType
                          })(<PSelect disabled={!isEdit} style={{ width: '100%' }} type="residentPlaceType" />)}
                        </Form.Item>
                      </>
                    );
                  })()
                }

                <Form.Item {...formItemLayout} label="户籍地址">
                  {getFieldDecorator('householdAddress', {
                    initialValue: info.householdAddress
                  })(<TextArea placeholder="" maxLength={100} disabled={!isEdit} autoSize={{ minRows: 1, maxRows: 3 }} />)}
                </Form.Item>
                <Form.Item {...formItemLayout} label="现住地址">
                  {getFieldDecorator('actualAddress', {
                    initialValue: info.actualAddress
                  })(<TextArea placeholder="" maxLength={100} disabled={!isEdit} autoSize={{ minRows: 1, maxRows: 3 }} />)}
                </Form.Item>
                <Form.Item {...formItemLayout} label="本职业工作年限">
                  <div style={{ display: 'flex', alignItems: 'center' }}>
                    {getFieldDecorator('workYear', {
                      initialValue: info.workYear
                    })(<Input placeholder="" maxLength={30} disabled={!isEdit} />)}
                    <span style={{ marginLeft: 8 }}>年</span>
                  </div>
                </Form.Item>
                {
                  //补考人员，并且是未核对的，需要确认是否已缴费
                  info.isMakeUp == '1' && info.materialApproveStatus == '0' &&
                  <Form.Item {...formItemLayout} label="确认是否缴交补考费" extra={<span style={{ color: '#f71c58' }}>该学员是补考人员，请核实是否已缴纳鉴定补考费。如确认未缴纳，则予以不通过。</span>}>
                    {getFieldDecorator('isMakeUpPay', {
                      initialValue: info.isMakeUpPay
                    })(<Radio.Group>
                      <Radio value={0}><span style={{ color: '#ff4d4f' }}>未缴费</span></Radio>
                      <Radio value={1}><span style={{ color: '#1890ff' }}>已缴费</span></Radio>
                    </Radio.Group>)}
                  </Form.Item>
                }
                {
                  //补考人员，并且是核对过的
                  info.isMakeUp == '1' && info.materialApproveStatus != '0' &&
                  <div>
                    <Form.Item {...formItemLayout} label="首次培训学校">
                      {getFieldDecorator('trainOrganName', {
                        initialValue: info.trainOrganName
                      })(<Input placeholder="" maxLength={30} disabled={true} />)}
                    </Form.Item><Form.Item {...formItemLayout} label="联系方式">
                      {getFieldDecorator('trainOrganPhone', {
                        initialValue: info.trainOrganPhone
                      })(<Input placeholder="" maxLength={30} disabled={true} />)}
                    </Form.Item>
                  </div>
                }

                {/* --------合同信息------- */}
                <h3>
                  合同信息
                  {
                    isEdit &&
                    <Button onClick={() => {
                      this.setState({ contractModal: true });
                    }} type="primary" style={{ marginLeft: 10 }}>选择新合同</Button>
                  }
                  {/* {
                    info.contractsCheck && <div style={{ color: 'red' }}>{info.contractsCheck}</div>
                  } */}
                </h3>
                <Form.Item {...formItemLayout} label="合同名称">
                  <Input value={comContractInfo ? comContractInfo.contractName : info.contractName} placeholder="" maxLength={30} disabled />
                </Form.Item>
                <Form.Item {...formItemLayout} label="有效期">
                  <Input value={
                    comContractInfo ?
                      (comContractInfo.effectStartDate ? `${comContractInfo.effectStartDate}~${comContractInfo.effectEndDate}` : '') :
                      (info.effectStartDate ? `${info.effectStartDate}~${info.effectEndDate}` : '')
                  } placeholder="" maxLength={30} disabled />
                </Form.Item>
                <Form.Item {...formItemLayout} label="合同文件">
                  <a
                    onClick={() => {
                      if (info.contractUrl) {
                        publicCommonFileFilePreview({
                          url: info.contractUrl,
                          isLoad: '1'
                        })
                          .then(data => {
                            if (data.data) {
                              window.open(data.data);
                            }
                          });
                      } else {
                        notification.warning({
                          message: '该合同未上传附件！',
                          description: '请先上传合同文件，方可查看。'
                        });
                      }
                    }}
                  >
                    点击查看
                </a>
                  <a
                    style={{ marginLeft: 15 }}
                    href={info.contractUrl}
                    target="_blank"
                    download
                  >
                    点击下载
                </a>
                  {/* {getFieldDecorator('contractUrl' , {
                  initialValue: info.contractUrl
                })(
                  <PFromUpload
                    key={moment().valueOf()}
                    disabled={true}
                    num={1}
                    disabled
                  />
                )} */}
                </Form.Item>

                {/* 就职记录 */}
                <h3>就职记录</h3>
                {
                  info&& <PTable
                    style={{ marginTop: 20 }}
                    columns={[
                      {
                        title: '就职企业',
                        dataIndex: 'comName',
                        key: 'comName'
                      },
                      {
                        title: '入职时间',
                        dataIndex: 'entryDate',
                        key: 'entryDate',
                      },
                      {
                        title: '离职时间',
                        dataIndex: 'leaveDate',
                        key: 'leaveDate',
                        render: value => value|| '-'
                      }
                    ]}
                    url="getPerWorkInfo"
                    pageParm={{pageNumber: 1,pageSize:10,perId:info.perId}}
                    forceUpdate={false}
                  />
                }
                {/* --------资格证信息------- */}
                <h3>资格证信息</h3>
                <Form.Item {...formItemLayout} label="证书类型">
                  {getFieldDecorator('perCerType', {
                    initialValue: certInfo.perCerType
                  })(<PSelect disabled style={{ width: '100%' }} type="perCerType" />)}
                </Form.Item>
                <Form.Item {...formItemLayout} label="证书编号">
                  {getFieldDecorator('cerNo', {
                    initialValue: certInfo.cerNo
                  })(<Input placeholder="" maxLength={30} disabled={true} />)}
                </Form.Item>
                <Form.Item {...formItemLayout} label="发证机关">
                  {getFieldDecorator('licenceOrg', {
                    initialValue: certInfo.licenceOrg
                  })(<Input placeholder="" maxLength={30} disabled={true} />)}
                </Form.Item>
                <Form.Item {...formItemLayout} label="发证日期">
                  {getFieldDecorator('licenceDate', {
                    initialValue: certInfo.licenceDate
                  })(<Input placeholder="" disabled disabled={true} />)}
                </Form.Item>
                {/* <Form.Item {...formItemLayout} label="培训单位">
                  {getFieldDecorator('nation', {
                    initialValue: ''
                  })(<PSelect type="nation" disabled />)}
                </Form.Item> */}
                <Form.Item {...formItemLayout} label="电子证">
                  <a href={certInfo.electronCerUrl} target="_blank">点击查看</a>
                </Form.Item>


                {
                  info.bonusCompareStatus == '3' &&
                  <>
                    {/* --------等级证信息------- */}
                    <h3>等级证信息</h3>
                    <Form.Item {...formItemLayout} label="证书编号">
                      {getFieldDecorator('gradeCertNo', {
                        initialValue: info.gradeCertNo
                      })(<Input placeholder="" maxLength={50} disabled={!isComparisonEdit} />)}
                    </Form.Item>
                    {/* <Form.Item {...formItemLayout} label="发证机关">
                      {getFieldDecorator('gradeCertOrg', {
                        initialValue: info.gradeCertOrg
                      })(<Input placeholder="" maxLength={30} disabled={true} />)}
                    </Form.Item> */}
                    <Form.Item {...formItemLayout} label="发证日期">
                      {getFieldDecorator('gradeCertDate', {
                        initialValue: info.gradeCertDate
                      })(<Input placeholder="" disabled disabled={true} />)}
                    </Form.Item>
                    {/* --------结业证信息------- */}
                    <h3>结业证信息</h3>
                    <Form.Item {...formItemLayout} label="证书编号">
                      {getFieldDecorator('graduateCertNo', {
                        initialValue: info.graduateCertNo
                      })(<Input placeholder="" maxLength={30} disabled={true} />)}
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="发证机关">
                      {getFieldDecorator('graduateCertOrg', {
                        initialValue: info.graduateCertOrg
                      })(<Input placeholder="" maxLength={30} disabled={true} />)}
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="发证日期">
                      {getFieldDecorator('graduateCertDate', {
                        initialValue: info.graduateCertDate
                      })(<Input placeholder="" disabled disabled={true} />)}
                    </Form.Item>


                    {/* --------补贴信息------- */}
                    <h3>补贴信息</h3>
                    <Form.Item {...formItemLayout} label="补贴政策类型">
                      {getFieldDecorator('bonusPolicy', {
                        initialValue: info.bonusPolicy
                      })(<Input placeholder="" maxLength={30} disabled={true} />)}
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="补贴对象类型">
                      {getFieldDecorator('bonusItem', {
                        initialValue: info.bonusItem
                      })(<Input placeholder="" maxLength={30} disabled={true} />)}
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="补贴对象名称">
                      {getFieldDecorator('bonusObject', {
                        initialValue: info.bonusObject
                      })(<Input placeholder="" maxLength={30} disabled={true} />)}
                    </Form.Item>
                    {/* <Form.Item {...formItemLayout} label="统一社会信用代码">
                      {getFieldDecorator('identifyCertOrg', {
                        initialValue: info.licenceOrg
                      })(<Input placeholder="" maxLength={30} disabled={true} />)}
                    </Form.Item> */}
                    <Form.Item {...formItemLayout} label="培训职业">
                      {getFieldDecorator('trainJob', {
                        initialValue: info.trainJob
                      })(<Input placeholder="" maxLength={30} disabled={true} />)}
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="培训等级">
                      {getFieldDecorator('trainGrade', {
                        initialValue: info.trainGrade
                      })(<Input placeholder="" maxLength={30} disabled={true} />)}
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="培训开始时间">
                      {getFieldDecorator('practiceStartDate', {
                        initialValue: info.practiceStartDate
                      })(<Input placeholder="" disabled disabled={true} />)}
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="培训结束时间">
                      {getFieldDecorator('practiceEndDate', {
                        initialValue: info.practiceEndDate
                      })(<Input placeholder="" disabled disabled={true} />)}
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="证书类型">
                      {getFieldDecorator('certType', {
                        initialValue: info.certType
                      })(<Input placeholder="" disabled disabled={true} />)}
                    </Form.Item>
                    <Form.Item {...formItemLayout} label="证书职业工种">
                      {getFieldDecorator('certJobType', {
                        initialValue: info.certJobType
                      })(<Input placeholder="" disabled disabled={true} />)}
                    </Form.Item>
                    {/* <Form.Item {...formItemLayout} label="备注">
                      {getFieldDecorator('remark', {
                        initialValue: info.remark
                      })(<Input.TextArea placeholder="" disabled disabled={true} />)}
                    </Form.Item> */}
                  </>
                }

                {
                  info.bonusCompareStatus != '3' &&
                  <>
                    {/* -----------图像材料----------- */}
                    <h3>图像材料</h3>
                    {
                      this.state.imgs.map((row, index) => {
                        return (
                          <Row gutter={16} key={index}>
                            {
                              row.map((item, idex) => {
                                if (!item) {
                                  return '';
                                }
                                return (
                                  <Col span={8}>
                                    <Form.Item key={idex + moment().valueOf()} style={{ textAlign: 'center' }} {...formItemLayout1} layout="vertical" label={<em style={{ display: 'block', textAlign: 'center', paddingRight: 16 }}>{item.label}</em>}>
                                      {getFieldDecorator(item.fieldsName, {
                                        initialValue: info[item.fieldsName]
                                      })(
                                        <PFromUpload
                                          key={idex + moment().valueOf()}
                                          disabled={!isEdit}
                                          num={1}
                                          types={item.types}
                                          size={item.size}
                                          sizeErrMsg={item.sizeErrMsg}
                                        />
                                      )}
                                    </Form.Item>
                                  </Col>
                                )
                              })
                            }
                          </Row>
                        );
                      })
                    }
                  </>
                }
                <section>
                  <span style={{
                    color: '#f5222d',
                    // text-indent  
                  }}>*</span>
                  我司{info.learnName && <span>（ <span style={{ color: '#F59A23' }}>{info.learnName}</span> ）</span>}承诺，由我司报名代理人{info.agentName}（{info.agentIdCardNo.replace(/(\d{4}).*(\d{3})/, '$1***********$2')},{info.agentPhone}）提交的报名信息真实有效，对因填报信息错误造成不符合培训及补贴申报条件的，由本企业自行承担相应责任和损失。
                </section>

                {
                  (info.materialApproveStatus == '1' || info.materialApproveStatus == '2') &&
                  <section style={{ marginTop: 30 }}>
                    <h3>材料核对记录</h3>
                    <div>
                      <span>核对人：</span>
                      <span>
                        {info.materialApprovePerName}
                        {
                          info.materialApprovePerIdCardNo &&
                          `(${info.materialApprovePerIdCardNo})`
                        }
                      </span>
                    </div>
                    <div>
                      <span>核对时间：</span>
                      <span>{info.materialApproveDate}</span>
                    </div>
                  </section>
                }
                <Button style={{ marginTop: 15 }} type="primary" onClick={() => {
                  this.setState({
                    recordShow: true
                  });
                }}>查看实习记录</Button>
              </Form>
            </div>
          }


          {/* 底部提交按钮 */}
          {
            info &&
            <div
              style={{
                position: 'absolute',
                bottom: 0,
                width: '100%',
                borderTop: '1px solid #e8e8e8',
                padding: '10px 16px',
                textAlign: 'left',
                left: 0,
                background: '#fff',
                borderRadius: '0 0 4px 4px'
              }}
            >
              <Button
                style={{
                  marginRight: 8
                }}
                onClick={() => {
                  if (isEdit || isComparisonEdit) {
                    this.setState({
                      isEdit: false,
                      isComparisonEdit: false,
                      comContractInfo: null //重置合同信息
                    });
                    this.props.form.resetFields();

                  } else {
                    // 关闭抽屉
                    this.props.setParentState({
                      personApplyId: ''
                    });
                  }
                }}
              >
                {isEdit || isComparisonEdit ? '取消编辑' : '返回'}
              </Button>
              {/* 非编辑模式 */}
              {
                (!isEdit && !isComparisonEdit) &&
                <>
                  <Button
                    type="primary"
                    disabled={info.materialApproveStatus == '1' || info.materialApproveStatus == '2'} // 0未核对，1通过，2不通过
                    style={{
                      marginRight: 8
                    }}
                    onClick={() => {
                      const isMakeUpPay = this.props.form.getFieldValue('isMakeUpPay')
                      //如果是补考人员，并且是材料没有审核的，这时候它还未缴费就不让审核通过
                      if (info.isMakeUp == '1' && info.materialApproveStatus == '0') {
                        if (isMakeUpPay == undefined) {
                          return $modal('请先确认是否缴费', '', null, 'warning');
                        } else if (this.props.form.getFieldValue('isMakeUpPay') == '0') {
                          return $modal('该成员还未缴费，不能核对通过！', '', null, 'warning');
                        }
                      }
                      $modal(
                        '确定提交',
                        '',
                        [{
                          text: '确定', type: 'primary', onPress: () => {
                            const subFun = () => {
                              const materialApprovePerName = this.state.editUser.name;
                              const materialApprovePerIdCardNo = this.state.editUser.idCardNo;
                              const { personApplyId } = this.props;
                              const value = {
                                personApplyId, materialApprovePerName, materialApprovePerIdCardNo
                              }
                              if (info.isMakeUp == '1' && info.materialApproveStatus == '0') {
                                value.isMakeUpPay = isMakeUpPay
                              }
                              trainGradeApplyDealMaterialApprove({ data: { ...value } }).then(res => {
                                this._getDetailInfo(this.props.personApplyId);
                                // 关闭抽屉
                                this.props.setParentState({
                                  // personApplyId: '',
                                  forceUpdate: true
                                }, () => {
                                  this.props.setParentState({
                                    forceUpdate: false
                                  });
                                });
                                // 提示
                                // $modal('提交成功！', '', null, 'success');
                                notification.success({
                                  message: '提交成功！'
                                });
                              });
                            }
                            // 获取人员基础信息
                            this._getUserInfo(subFun);
                          }
                        }, { text: '取消' }],
                        'success'
                      );
                    }}
                  >
                    材料核对通过
                  </Button>
                  <Button
                    type="danger"
                    disabled={info.materialApproveStatus == '1' || info.materialApproveStatus == '2'} // 0未核对，1通过，2不通过
                    onClick={() => {
                      this.setState({
                        refuseModal: true
                      });
                    }}
                  >
                    材料核对不通过
                  </Button>
                </>
              }

              {/* 编辑模式 */}
              {
                (isEdit || isComparisonEdit) &&
                <>
                  <Button
                    type="primary"
                    disabled={info.applyStatus == '3'} // 已撤销的不能操作
                    style={{
                      marginRight: 8
                    }}
                    onClick={this._onSubmit}
                  >
                    提交修改
                  </Button>
                </>
              }
            </div>
          }
          {
            info &&
            <InternshipRecord
              visible={this.state.recordShow}
              name={info.fullname}
              uid={info.uid}
              onClose={() => {
                this.setState({
                  recordShow: false
                });
              }}
            />
          }

          <Modal
            title="材料核对不通过"
            visible={this.state.refuseModal}
            okText="确定"
            cancelText="取消"
            onCancel={() => {
              this.setState({
                refuseModal: false
              });
            }}
            onOk={() => {
              // $modal('班级取消成功！','已发送取消通知到相关人员。', null, 'success');

              const materialApproveFailReason = this.state.refuseReason;
              if (materialApproveFailReason) {
                const subFun = () => {
                  const materialApprovePerName = this.state.editUser.name;
                  const materialApprovePerIdCardNo = this.state.editUser.idCardNo;
                  const { personApplyId } = this.props;
                  const value = {
                    personApplyId, materialApproveFailReason, materialApprovePerName, materialApprovePerIdCardNo
                  }
                  if (info.isMakeUp == '1' && info.materialApproveStatus == '0') {
                    const isMakeUpPay = this.props.form.getFieldValue('isMakeUpPay')
                    value.isMakeUpPay = isMakeUpPay
                  }
                  trainGradeApplyMaterialApproveReject({ data: { ...value } }).then(res => {
                    $modal('提交成功！', '保安公司可查看不通过原因。', null, 'success');
                    this.setState({
                      refuseModal: false,
                      refuseReason: ''
                    });
                    this._getDetailInfo(this.props.personApplyId);
                    this.props.setParentState({
                      personApplyId: '',
                      forceUpdate: true
                    }, () => {
                      this.props.setParentState({
                        forceUpdate: false
                      });
                    });
                  });
                }
                // 获取人员基础信息
                this._getUserInfo(subFun);
              } else {
                message.error("请输入不通过原因及修改意见")
              }
            }}
          >
            <label><span style={{ color: 'red' }}>*</span>不通过原因:</label>
            <Input.TextArea value={this.state.refuseReason} onChange={e => {
              this.setState({
                refuseReason: e.target.value
              });
            }} placeholder="请输入不通过原因及修改意见。" />
          </Modal>
        </Drawer>
        {
          info &&
          <SelectContactByPerId
            perId={info.perId}
            onlySearchPerId="1"
            visibale={this.state.contractModal}
            onSelect={comContractList => {
              console.log(comContractList);
              this.setState({
                comContractInfo: comContractList[0]
              });
              // this.setState({
              //   comContractList
              // });
            }}
            onClose={() => {
              this.setState({
                contractModal: false
              });
            }}
          />
        }
      </div>
    );
  }
}
