import React, { PureComponent } from 'react';
import { Tabs } from 'antd';
import style from "styled-components";
import StudyRecord from './StudyRecord';
import FaceRecognition from './FaceRecognition';

const { TabPane } = Tabs;

export default class QualificationStudyRecord extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {};
  }

  componentDidMount = () => {
  }
  render() {
    return (
      <Container>
        <Tabs defaultActiveKey='1'>
          <TabPane tab="资格证课程学习记录" key="1" >
            <StudyRecord/>
          </TabPane>
          <TabPane tab="学员人脸识别认证记录" key="2" >
            <FaceRecognition/>
          </TabPane>
        </Tabs>
      </Container>
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
  width:100%;
  height:100%;
`;
