
import style from "styled-components";
import { trainGradeCancelClass } from '../../../../services/bkt/apis';
import $modal from '../../../../utils/modal';
const warnColor = '#F59A23';
const okColor = '#4B7902';
const errColor = '#D9001B';
export default function () {
  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number',
      fixed: 'left',
      width: 80
    },
    {
      title: '班级状态',
      dataIndex: 'classStatus',
      key: 'classStatus',
      fixed: 'left',
      width: 100,
      render: value => {
        let text = '-';
        let color = '';
        switch (true) {
          case value == '0':
            text = '待审核';
            color = warnColor;
            break;
          case value == '1':
            text = '审核通过';
            color = okColor;
            break;
          case value == '2':
            text = '审核不通过';
            color = errColor;
            break;
          case value == '3':
            text = '已结束';
            color = '';
            break;
          case value == '4':
            text = '待提交';
            color = warnColor;
            break;
          case value == '9':
            text = '已取消';
            color = '#ddd';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '班级名称',
      dataIndex: 'className',
      key: 'className',
      fixed: 'left',
      width: 140,
      render: value => value || '-'
    },
    {
      title: '班级人数',
      dataIndex: 'personCount',
      key: 'personCount',
      render: value => value || '0'
    },
    {
      title: <div style={{minWidth: 120}}>
        <span>考试成绩确认状态</span><br />
        <span>（告知公安机关）</span>
      </div>,
      dataIndex: 'scoreState',
      key: 'scoreState',
      render: value => {
        let text = '';
        let color = '';
        switch (true) {
          case value == '0':
            text = '未确认';
            color = warnColor;
            break;
          case value == '1':
            text = '已确认';
            color = okColor;
            break;
          default:
            text = '未确认';
            color = warnColor;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '申请时间',
      dataIndex: 'classApplyDate',
      key: 'classApplyDate',
      render: (value, record) => {
        return (
          <span>{value?value:'-'}</span>
        )
      }
    },
    // {
    //   title: '开班时间',
    //   dataIndex: 'classStartDate',
    //   key: 'classStartDate',
    //   render: (value, record) => {
    //     const { classStartDate, classEndDate } = record;
    //     if (!!classStartDate) {
    //       return `${classStartDate}~${classEndDate?classEndDate: ''}`;
    //     }
    //     return '-';
    //   }
    // },
    {
      title: '实操培训开班时间',
      dataIndex: 'particeStartDate',
      key: 'particeStartDate',
      render: (value, record) => {
        const { practiceStartDate, practiceEndDate } = record;
        if (!!practiceStartDate) {
          return `${practiceStartDate}~${practiceEndDate}`;
        }
        return '-';
      }
    },
    {
      title: '结业-理论考试时间',
      dataIndex: 'graduateComputerStartDate',
      key: 'graduateComputerStartDate',
      render: (value, record) => {
        const { graduateComputerStartDate, graduateComputerEndDate } = record;
        if (!!graduateComputerStartDate) {
          return `${graduateComputerStartDate}~${graduateComputerEndDate}`;
        }
        return '-';
      }
    },
    {
      title: '结业-实操考试时间',
      dataIndex: 'graduatePracticeStartDate',
      key: 'graduatePracticeStartDate',
      render: (value, record) => {
        const { graduatePracticeStartDate, graduatePracticeEndDate } = record;
        if (!!graduatePracticeStartDate) {
          return `${graduatePracticeStartDate}~${graduatePracticeEndDate}`;
        }
        return '-';
      }
    },
    {
      title: '鉴定-理论考试时间',
      dataIndex: 'identifyComputerStartDate',
      key: 'identifyComputerStartDate',
      render: (value, record) => {
        const { identifyComputerStartDate, identifyComputerEndDate } = record;
        if (!!identifyComputerStartDate) {
          return `${identifyComputerStartDate}~${identifyComputerEndDate}`;
        }
        return '-';
      }
    },
    {
      title: '鉴定-实操考试时间',
      dataIndex: 'identifyPracticeStartDate',
      key: 'identifyPracticeStartDate',
      render: (value, record) => {
        const { identifyPracticeStartDate, identifyPracticeEndDate } = record;
        if (!!identifyPracticeStartDate) {
          return `${identifyPracticeStartDate}~${identifyPracticeEndDate}`;
        }
        return '-';
      }
    },
    {
      title: '操作',
      dataIndex: 'operation',
      key: 'operation',
      fixed: 'right',
      width: 220,
      render: (text, record) => {
        const { gradeClassId, classStatus, scoreState } = record;
        return (
          <Container>
            <a onClick={() => {
              this._showClassInfo(gradeClassId, classStatus);
            }}>查看</a>
            <a onClick={() => {
              this.setState({
                gradeClassId,
                classStatus,
                scoreState,
                classPersonsShow: true
              });

            }}>班级成员</a>
            {/* <a onClick={() => {


            }}>导出</a> */}
            {
              classStatus == '1' && scoreState == 0 &&
              <a style={{ color: '#D9001B' }} onClick={() => {
                $modal(
                  '即将取消班级，是否继续？',
                  <span style={{ color: 'D9001B' }}>班级取消后，将向班级内的人员发送取消通知。取消后无法再开启，需重新创建。</span>,
                  [
                    {
                      text: '继续',
                      type: 'primary',
                      onPress: () => {
                        trainGradeCancelClass({data: {gradeClassId}}).then(res => {
                          this._updateTable();
                          $modal('班级取消成功！','已发送取消通知到相关人员。', null, 'success');
                        });
                      }
                    },
                    {
                      text: '取消',
                    }
                  ]
                );

              }}>取消</a>
            }
          </Container>
        );
      }
    }
  ];
}

const Container = style.div`
  a{
    margin-left: 10px;
    &:first-child{
      margin-left: 0;
    }
  }
`;
