
/* 
*visible 显示
*gradeClassId 当前所在id
 */
import React, { Component } from "react";
import SearchForm from './SearchForm';
// import st from 'styled-components';
import {
  Modal,
  Button
} from "antd";
import { trainGradeClassPersonAdd } from '../../../../../services/bkt/apis';
import $modal from '../../../../../utils/modal';
import BTable from '../../../../../components/Pro/BTable';
import columnFun from './columns';

export default class SelectStudents extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false, //是否更新表格
      pageParm: { //表格参数
        pageSize: '10',
        pageNumber: '1',
      },
      searchDataReady: false, //筛选参数是否准备就绪

      selectedRowKeys: [],  //选中状态
      selectedRowRows: [], //选中地项目
    };
  }
  componentDidMount() {

  }
  componentWillReceiveProps(props) {
    if (props.visible) {

    } else {

    }
  }
  _search = (values) => {
    this.setState({
      pageParm: {
        ...this.state.pageParm,
        ...values
      },
      searchDataReady: true
    });
  }
  _updateTable = () => {
    this.setState({
      forceUpdate: true
    }, () => {
      this.setState({
        forceUpdate: false
      });
    });
  }
  render() {
    const columns = columnFun.call(this);
    return (
      <Modal
        title="选择学员"
        width={'80%'}
        okText="确定"
        cancelText="上一步"
        destroyOnClose={true}
        visible={this.props.visible}
        onCancel={() => {
          this.setState({
            selectedRowKeys: [],
            selectedRowRows: [],
          });
          this.props.setParentState && this.props.setParentState({
            selectStudentsShow: false,  //关闭当前
          });
        }}
        onOk={() => {
          const { selectedRowKeys, selectedRowRows } = this.state;
          if (selectedRowKeys.length == 0) {
            return $modal('请选择人员', '');
          }

          // 有id为编辑查看模式
          if (this.props.gradeClassId) {
            // 直接提交
            submitStudents.call(this, this.props.gradeClassId);
          } else {
            $modal(
              '即将提交开班信息给到公安系统审核，是否继续？',
              <span style={{ color: 'D9001B' }}>开班申请审核通过后，才可进行考试安排，预计48小时内完成审核，请注意考试时间安排。</span>,
              [
                {
                  text: '继续',
                  type: 'primary',
                  onPress: () => {
                    if (this.props.onSub) {
                      console.log(this.props.onSub)
                      this.props.onSub(gradeClassId => {
                        console.log(gradeClassId);
                        submitStudents.call(this, gradeClassId);
                      });
                    } else {
                      submitStudents.call(this, this.props.gradeClassId);
                    }
                  }
                },
                {
                  text: '取消'
                }
              ]
            );
          }

          function submitStudents(gradeClassId) {
            const data = selectedRowRows.map(item => {
              const { uid, gid, personApplyId } = item;
              return {
                gradeClassId,
                uid,
                gid,
                personApplyId
              };
            });
            trainGradeClassPersonAdd({ data }).then(res => {
              // if(this.props.preModal == 'classPersonsShow') {
              //   this.props.setParentState({
              //     classPersonsShow: true
              //   });
              // }else {
              //   $modal('提交成功！', '', null, 'success');
              // }
              this.props.onOk && this.props.onOk();
              this.setState({
                selectedRowKeys: [],
                selectedRowRows: [],
              });
              this.props.setParentState({
                selectStudentsShow: false
              });
            });
          }
        }}
      >
        <SearchForm
          style={{ marginLeft: 10 }}
          onSearch={this._search}
        />
        {
          this.state.searchDataReady &&
          <BTable
            style={{ marginTop: 20 }}
            columns={columns}
            dataSetKey='uid'
            url="trainGradeClassPersonAddPage"
            pageParm={this.state.pageParm}
            forceUpdate={this.state.forceUpdate}
            pagination={{
              showTotal: total => `总共 ${total} 条`,
              pageSizeOptions: ["10", "20", "40", "100", "500"],
            }}
            rowSelection={{
              selectedRowKeys: this.state.selectedRowKeys,
              onChange: (selectedRowKeys) => {
                this.setState({ selectedRowKeys
                  // , selectedRowRows 
                });
              },
              onSelect: (record, selected, selectedRows) => {
                const selectId = JSON.parse(JSON.stringify(this.state.selectedRowKeys));
                const selectedRowRows = JSON.parse(JSON.stringify(this.state.selectedRowRows));
                if (selected === true) {
                  selectId.push(record.uid);
                  selectedRowRows.push(record);
                } else {
                  for (let i = 0; i < selectId.length; i++) {
                    if (selectId[i] === record.uid) {
                      selectId.splice(i, 1);
                      selectedRowRows.splice(i, 1);
                      break;
                    }
                  }
                }
                this.setState({
                  selectedRowKeys: selectId,
                  selectedRowRows
                });
              },
              onSelectAll: (selected, selectedRows) => {
                // let selectId = [];
                let selectId = JSON.parse(JSON.stringify(this.state.selectedRowKeys));
                let selectedRowRows = JSON.parse(JSON.stringify(this.state.selectedRowRows));
                if (selected === true) {
                  for (let i = 0; i < selectedRows.length; i++) {
                    //不存在的话就添加
                    if(selectId.indexOf(selectedRows[i].uid)<0){
                      selectId.push(selectedRows[i].uid);
                      selectedRowRows.push(selectedRows[i]);
                    }
                  }
                } else {
                  // for (let i = 0; i < selectedRows.length; i++) {
                  //   //如果存在就删除
                  //   const indexOfValue = selectId.indexOf(selectedRows[i].uid);
                  //   if(indexOfValue>-1){
                  //     selectId.splice(indexOfValue, 1);
                  //     selectedRowRows.splice(indexOfValue, 1);
                  //   }
                  // }
                  selectId = [];
                  selectedRowRows = [];
                }
                this.setState({
                  selectedRowKeys: selectId,
                  selectedRowRows
                });
              }
            }}
          />
        }
      </Modal>
    );
  }
}

// const Btns = st.div`
//   margin-top: 15px;
//   >button{
//     margin-left: 15px;
//     &:first-child{
//       margin-left: 0;
//     }
//   }
// `;
