import React, { Component } from "react";
import {
  Button,
  Form,
  Input,
  Select,
  DatePicker
} from "antd";
// import moment from 'moment';
const dateFomate = 'YYYY-MM-DD';
import {
  
} from '../../../../services/api';
const { Option } = Select;
const { RangePicker } = DatePicker;
@Form.create()
export default class SearchForm extends Component {
  constructor(props) {
    super(props);
    this.state = {
    }
  }
  componentDidMount() {
    this._search();
  }

  _search = (e) => {
    e && e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        // 实操培训时间
        if(values.practiceDate.length == 0) {
          values.practiceStartDate = '';
          values.practiceEndDate = '';
        }else {
          values.practiceStartDate = values.practiceDate[0].format(dateFomate);
          values.practiceEndDate = values.practiceDate[1].format(dateFomate);
        }
        Reflect.deleteProperty(values, 'practiceDate');

        // 理论考试时间
        if(values.graduateComputerDate.length == 0) {
          values.graduateComputerStartDate = '';
          values.graduateComputerEndDate = '';
        }else {
          values.graduateComputerStartDate = values.graduateComputerDate[0].format(dateFomate);
          values.graduateComputerEndDate = values.graduateComputerDate[1].format(dateFomate);
        }
        Reflect.deleteProperty(values, 'graduateComputerDate');

        // 实操考试时间
        if(values.graduatePracticeDate.length == 0) {
          values.graduatePracticeStartDate = '';
          values.graduatePracticeEndDate = '';
        }else {
          values.graduatePracticeStartDate = values.graduatePracticeDate[0].format(dateFomate);
          values.graduatePracticeEndDate = values.graduatePracticeDate[1].format(dateFomate);
        }
        Reflect.deleteProperty(values, 'graduatePracticeDate');

        // 开班时间
        if(values.classDate.length == 0) {
          values.classStartDate = '';
          values.classEndDate = '';
        }else {
          values.classStartDate = values.classDate[0].format(dateFomate);
          values.classEndDate = values.classDate[1].format(dateFomate);
        }
        Reflect.deleteProperty(values, 'classDate');
        // 搜索的时候重置为第一页
        values.pageNumber = 1;
        this.props.onSearch(values);
      }
    });
  }
  _reset = () => {
    this.props.form.resetFields();
    this._search();
}
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Form layout="inline" onSubmit={this._search}> 
        <Form.Item style={{marginTop: 10}} label="实操培训开班时间">
          {getFieldDecorator('practiceDate', {
            initialValue: []
          })(
            <RangePicker
              disabledDate={current => {
                // return current > moment().endOf('day')
                // return current && current > moment().endOf('day')
              }}
              // disabledTime={}
              format="YYYY-MM-DD"
            />
          )}
        </Form.Item>
        <Form.Item style={{marginTop: 10}} label="结业-理论考试时间">
          {getFieldDecorator('graduateComputerDate', {
            initialValue: []
          })(
            <RangePicker
              disabledDate={current => {
                // return current > moment().endOf('day')
                // return current && current > moment().endOf('day')
              }}
              // disabledTime={}
              format="YYYY-MM-DD"
            />
          )}
        </Form.Item>
        <Form.Item style={{marginTop: 10}} label="结业-实操考试时间">
          {getFieldDecorator('graduatePracticeDate', {
            initialValue: []
          })(
            <RangePicker
              disabledDate={current => {
                // return current > moment().endOf('day')
                // return current && current > moment().endOf('day')
              }}
              // disabledTime={}
              format="YYYY-MM-DD"
            />
          )}
        </Form.Item>

      
        <br />
        <Form.Item style={{marginTop: 10}} label="开班时间">
          {getFieldDecorator('classDate', {
            initialValue: []
          })(
            <RangePicker
              disabledDate={current => {
                // return current > moment().endOf('day')
                // return current && current > moment().endOf('day')
              }}
              // disabledTime={}
              format="YYYY-MM-DD"
            />
          )}
        </Form.Item>
        <Form.Item style={{marginTop: 10}} label="班级名称">
          {getFieldDecorator('className', {
            initialValue: ''
          })(
            <Input placeholder="" />
          )}
        </Form.Item>
        
        <Form.Item style={{marginTop: 10}} label="班级状态">
          {getFieldDecorator('classStatus', {
            initialValue: ''
          })(
            <Select style={{minWidth: 200}} >
              <Option value="">全部</Option>
                  <Option value="0">待审核</Option>
                  <Option value="1">审核通过</Option>
                  <Option value="2">审核不通过</Option>
                  <Option value="3">已结束</Option>
                  <Option value="4">待提交</Option>
                  <Option value="9">已取消</Option>
            </Select>
          )}
        </Form.Item>
        {/* btns */}
        <Form.Item style={{marginTop: 10}} label=" " colon={false}>
          <Button type="primary" onClick={this._search}>搜索</Button>
        </Form.Item>
        <Form.Item style={{marginTop: 10}} label=" " colon={false}>
          <Button onClick={this._reset}>重置</Button>
        </Form.Item>
      </Form>
    );
  }
}
