import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import { withRouter } from 'dva/router';
import {
  Button, Alert, Popover,
  Tabs,
  Input,
  Select,
  DatePicker 
} from 'antd';
import columnFun from './columns';
import SubDrawer from './SubDrawer';
import tablePage from '../../../../utils/hoc/tablePage';
import store from 'store';
import moment from 'moment';
const { TabPane } = Tabs;
const { Option } = Select;
const { RangePicker } = DatePicker;

@connect(state => ({
  global: state.global
}))
@withRouter
@tablePage({ type: 'bkt' })
export default class StudentManagement extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      //抽屉
      drawerVisble: false,
      personInternLineId: '',  //当前选中的id
    };
  }

  componentDidMount() {
  }
  // 表格渲染
  renderOrderList = () => {
    const columns = columnFun.call(this);
    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <PageTable
        columns={columns}
        url="grade_trainInternLineApprovePage"
        scroll={{ x: '1300px' }}
      />
    );
  };

  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator } = this.props.form;
    return (
      <div style={{ margin: 15 }}>
        <Tabs>
          <TabPane tab="等级证学员实习审核" key="1" />
        </Tabs>
        <Alert
          message={<div style={{ color: '#333' }}>
            实习审核：本页面显示从报名公司审核通过后的学员实习记录，培训机构相关人员需要进行二次审核，审核通过后，该条实习记录才为有效，并记录实习总时长。
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <SearchForm
           arrange={values => {
            const { date } = values;
            // 实习日期
            if(date.length == 2) {
              values.startDate = moment(date[0]).format('YYYY-MM-DD');
              values.endDate = moment(date[1]).format('YYYY-MM-DD');
            }else {
              values.startDate = '';
              values.endDate = '';
            }
            Reflect.deleteProperty(values, 'date');
            return values;
          }}
        >
          <>
            <Form.Item  label="关键词">
              {getFieldDecorator('keyword', {
                initialValue: ''
              })(
                <Input placeholder="请输入学员名称/身份证/手机号码" />
              )}
            </Form.Item>
            <Form.Item  label="培训机构审核状态">
              {getFieldDecorator('trainApproveStatus', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 200 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未审核</Option>
                  <Option value="1">审核通过</Option>
                  <Option value="2">审核不通过</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item  label="保安公司名称">
              {getFieldDecorator('learnName', {
                initialValue: ''
              })(
                <Input placeholder="请输入保安公司名称" />
              )}
            </Form.Item>

            <Form.Item  label="实习日期">
              {getFieldDecorator('date', {
                initialValue: []
              })(
                <RangePicker
                  disabledDate={current => {
                    // return current > moment().endOf('day')
                    // return current && current > moment().endOf('day')
                  }}
                  // disabledTime={}
                  format="YYYY-MM-DD"
                />
              )}
            </Form.Item>
          </>
        </SearchForm>
        <Btns>
          {/* <Popover content={<p style={{ padding: 10 }}>搜索后可导出搜索结果</p>} title="温馨提示："> */}
            <Button
              type="primary"
              onClick={() => {
                let { searchData } = this.props;
                searchData = JSON.parse(JSON.stringify(searchData));
                Reflect.deleteProperty(searchData, 'pagesize');
                Reflect.deleteProperty(searchData, 'pageNumber');
                let queryStr = '';
                Object.keys(searchData).forEach(key => {
                  queryStr += `${key}=${searchData[key]}&`;
                });
                queryStr = '?' + queryStr.slice(0, -1);
                console.log(queryStr);
                window.open('/bkt_api/train/intern/export/train/line' + queryStr + '&sessionId=' + store.get('saas')['sessionId']);
              }}
            >
              导出实习记录
            </Button>
          {/* </Popover> */}

        </Btns>
        {/* 表格 */}
        {this.renderOrderList()}

        {/* 修改弹窗 */}
        <SubDrawer
          personInternLineId={this.state.personInternLineId}
          updateTable={() => {
            this.setState({personInternLineId: ''});
            this.props.updateTable();
          }}
          onClose={() => {
            this.setState({personInternLineId: ''});
          }}
        />
      </div >
    );
  }
}

const Btns = st.div`
  margin-top: 15px;
  button {
    margin-right: 15px;
  }
`;