import React, { Component } from 'react';
import { connect } from 'dva';
import {
  Form, Input, Row, Col, Button, Radio, Steps, Checkbox, Table, TimePicker, Icon
} from 'antd';
import Drawer from "react-motion-drawer";
import { enterpriseCompanyComBaseInfoGetComBaseInfoById } from "../../../services/api";

import '../Task.less';

const FormItem = Form.Item;
const { Step } = Steps;

/*
固定班制---设置出勤班次 */
const columns1 = [{
  title: '工作日',
  dataIndex: 'workday',
  key: '2',
}, {
  title: '班次详情',
  dataIndex: 'detail',
  key: '3',
}, {
  title: '操作',
  dataIndex: 'option',
  key: '4',
  render: (text) => {
    return <div style={{ color: "rgba(15,113,255,1)" }}>{text}</div>;
  }
}];
const dataSource1 = [{
  key: '1',
  workday: '周一',
  detail: "休息",
  option: '选择班次'
}, {
  key: '2',
  workday: '周二',
  detail: "休息",
  option: '选择班次'
}, {
  key: '3',
  workday: '周三',
  detail: "休息",
  option: '选择班次'
}, {
  key: '4',
  workday: '周四',
  detail: "休息",
  option: '选择班次'
}, {
  key: '5',
  workday: '周五',
  detail: "休息",
  option: '选择班次'
}, {
  key: '6',
  workday: '周六',
  detail: "休息",
  option: '选择班次'
}, {
  key: '7',
  workday: '周日',
  detail: "休息",
  option: '选择班次'
}];


/* 排班制----设置出勤班次 */
const columns2 = [{
  title: '列号',
  dataIndex: 'list',
  key: '1',
}, {
  title: '班次名称',
  dataIndex: 'banci',
  key: '2',
}, {
  title: '时间安排',
  dataIndex: 'time',
  key: '3',
  render: (text) => {
    return <div style={{ color: "rgba(15,113,255,1)" }}>{text}</div>;
  }
}];
const dataSource2 = [{
  key: '1',
  banci: "班次A",
  time: '09:00-12:00'
}, {
  key: '2',
  banci: "一天3班3个次日班",
  time: '09:00-11:00 | 12:00 -14:00 | 15:00-18:00'
}];

/* 排班制----周期性排班设置 */
const columns3 = [{
  title: '周期名称',
  dataIndex: 'list',
  key: '1',
}, {
  title: '周期天数',
  dataIndex: 'banci',
  key: '2',
}, {
  title: '启用班次',
  dataIndex: 'time',
  key: '3',
  render: (text) => {
    return <div style={{ color: "rgba(15,113,255,1)" }}>{text}</div>;
  }
}, {
  title: '操作',
  dataIndex: 'time',
  key: '4',
  render: (text) => {
    return <div style={{ color: "rgba(15,113,255,1)" }}>{text}</div>;
  }
}];
const dataSource3 = [{
  key: '1',
  list: '1',
  banci: "班次A",
  time: '09:00-12:00'
}, {
  key: '2',
  list: '2',
  banci: "一天3班3个次日班",
  time: '09:00-11:00 | 12:00 -14:00 | 15:00-18:00'
}];


@connect(state => ({
  profile: state.profile,
}))


@Form.create()

export default class Information extends Component {

  state = {
    selectedTags: [],
    pagenav: {
      current: 1,
      pageSize: 10,
      showQuickJumper: true,
      showSizeChanger: true,
      showTotal: total => `总共 ${total} 条`,
      onShowSizeChange: (current, pageSize) => {
        const pagenav = Object.assign({}, this.state.pagenav);
        pagenav.current = current;
        pagenav.pageSize = pageSize;
        this.setState({ pagenav });
        setTimeout(() => {
          this.bbdExampersonPage();
        });
      },
      onChange: (page, pageSize) => {
        const pagenav = Object.assign({}, this.state.pagenav);
        pagenav.current = page;
        pagenav.pageSize = pageSize;
        this.setState({ pagenav });
        setTimeout(() => {
          this.bbdExampersonPage();
        });
      },
      total: 0,
    }
  }

  componentDidMount() {
    //this.setState({ open: true });
    enterpriseCompanyComBaseInfoGetComBaseInfoById({}).then((data) => {
      console.log(data, 'componentDidMount');
    });
  }

  handleSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFieldsAndScroll((err, values) => {
      if (!err) {
        this.props.dispatch({
          type: 'form/submitRegularForm',
          payload: values,
        });
      }
    });
  };
  callback = (key) => {
    console.log(key);
  };

  handleChange(tag, checked) {
    const { selectedTags } = this.state;
    const nextSelectedTags = checked ?
      [...selectedTags, tag] :
      selectedTags.filter(t => t !== tag);
    console.log('You are interested in: ', nextSelectedTags);
    this.setState({ selectedTags: nextSelectedTags });
  }

  /* 验证手机号码 */
  checkPhone = (rule, value, callback) => {
    if (value && !(/^1[0-9]{10}$/).test(value)) {
      callback('请输入正确的手机号码！');
    } else {
      callback();
    }
  };




  render() {
    const { submitting } = this.props;
    const { getFieldDecorator } = this.props.form;

    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 7 },
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 12 },
        md: { span: 10 },
      },
    };

    const submitFormLayout = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 10, offset: 7 },
      },
    };

    return (
      <div className="CreateTask">
        <div className="Steps">
          <Steps current={1}>
            <Step title="基本信息" />
            <Step title="考勤配置" />
            <Step title="发布设置" />
          </Steps>
        </div>
        <Form
          onSubmit={this.handleSubmit}
          style={{ marginTop: 24 }}
        >
          <FormItem
            {...formItemLayout}
            label="任务小组名称"
          >
            {getFieldDecorator('address', {
              rules: [{ required: true, message: '请输入' }],
            })(
              <Input />
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="选择出勤类型"
          >
            {getFieldDecorator('branch', {
              rules: [{
                required: true, message: '请选择',
              }],
            })(
              <Radio.Group>
                <Radio className="radioStyle" value="1">固定班制（每天出勤时间一样） <span className="exclamation"><Icon type="exclamation-circle" />适用于：每天固定上下班的任务。</span></Radio>
                <Radio className="radioStyle" value="1">排班制（自定义设置出勤时间）<span className="exclamation"><Icon type="exclamation-circle" />适用于：每天多个班次进行轮流上岗的任务。</span></Radio>
                <Radio className="radioStyle" value="1">自由班制（不设置班次，可随时打卡出勤，计算工时）</Radio>
              </Radio.Group>
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="设置出勤班次"
          >
            {getFieldDecorator('branch', {
              rules: [{
                required: true, message: '请选择',
              }],
            })(
              <Checkbox.Group className="checkbox-group">
                <Row>
                  <Col span={3}><Checkbox value="A">周一</Checkbox></Col>
                  <Col span={3}><Checkbox value="B">周二</Checkbox></Col>
                  <Col span={3}><Checkbox value="C">周三</Checkbox></Col>
                  <Col span={3}><Checkbox value="D">周四</Checkbox></Col>
                  <Col span={3}><Checkbox value="E">周五</Checkbox></Col>
                  <Col span={3}><Checkbox value="E">周六</Checkbox></Col>
                  <Col span={3}><Checkbox value="E">周日</Checkbox></Col>
                </Row>
              </Checkbox.Group>,
            )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="设置出勤班次"
          >
            {getFieldDecorator('branch', {
              rules: [{
                required: true, message: '请选择',
              }],
            })(
              <div>
                <Button
                  onClick={() => {
                    this.setState({ open: true });
                    window.setTimeout(() => {
                      console.log(this.state.open);
                    });
                  }}
                  style={{ marginBottom: 16 }}
                  type="primary"
                  ghost
                >选择默认班次</Button>
                <Table pagination={false} columns={columns1} dataSource={dataSource1} />
              </div>
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="设置出勤班次"
          >
            {getFieldDecorator('branch', {
              rules: [{
                required: true, message: '请选择',
              }],
            })(
              <div>
                <Button style={{ marginBottom: 16 }} type="primary" ghost>添加班次</Button>
                <Table pagination={false} columns={columns2} dataSource={dataSource2} />
              </div>
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="周期性排班设置"
          >
            {getFieldDecorator('branch', {
              rules: [{
                required: true, message: '请选择',
              }],
            })(
              <div>
                <Button style={{ marginBottom: 16 }} type="primary" ghost>添加周期</Button>
                <Table pagination={false} columns={columns3} dataSource={dataSource3} />
              </div>
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="设置出勤起点"
          >
            {getFieldDecorator('company', {
              rules: [{
                required: true, message: '请输入',
              }],
            })(
              <Row>
                <Col span={12}>
                  <TimePicker style={{ width: "100%" }} />
                </Col>
                <Col span={12}>
                  <span className="exclamation"><Icon type="exclamation-circle" />每日到达起点时间才打卡并计算工时</span>
                </Col>
              </Row>
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="设置出勤地点"
          >
            {getFieldDecorator('address', {
              rules: [{ required: true, message: '请选择' }],
            })(
              <Row span={24}>
                <Row>
                  <Col style={{ textAlign: 'right' }} span={4}>有效范围：</Col><Col span={20}><Input addonAfter="米" placeholder="请输入" /></Col>
                </Row>
                <Row>
                  <dl className="dl-list">
                    <dt>出勤地点</dt>
                    <dd>福建省厦门市集美区软件园3期城毅大街2342号<Icon type="minus-circle-o" /></dd>
                    <dd>福建省厦门市集美区软件园3期城毅大街2342号<Icon type="minus-circle-o" /></dd>
                    <dd>福建省厦门市集美区软件园3期城毅大街2342号<Icon type="minus-circle-o" /></dd>
                    <dd className="lastDD"><Icon type="plus" />添加</dd>
                  </dl>
                </Row>
                <Row>
                  <Col style={{ textAlign: 'right' }} span={4}>根据wifi出勤:</Col>
                </Row>
                <Row>
                  <dl className="dl-list">
                    <dt>MAC地址</dt>
                    <dd>福建省厦门市集美区软件园3期城毅大街2342号<Icon type="minus-circle-o" /></dd>
                    <dd>福建省厦门市集美区软件园3期城毅大街2342号<Icon type="minus-circle-o" /></dd>
                    <dd>福建省厦门市集美区软件园3期城毅大街2342号<Icon type="minus-circle-o" /></dd>
                    <dd className="lastDD"><Icon type="plus" />添加</dd>
                  </dl>
                </Row>
              </Row>
              )}
          </FormItem>
          <FormItem {...submitFormLayout} style={{ marginTop: 32 }}>
            <Button loading={submitting}>
              暂存
            </Button>
            <Button type="primary" style={{ marginLeft: 8 }} htmlType="submit">下一步</Button>
          </FormItem>
        </Form>
        {/*         出勤设置-固定班次--添加班次
 */}
        <Drawer
          overlayColor="rgba(0, 0, 0,0)"
          right
          open={this.state.open}
          noTouchClose
          width={600}
          onChange={(open) => {
            this.setState({ open });
          }}
        >
          <div className="drawer">
            <div className="drawer-header">
              选择班次 <Button type="primary" ghost>新增班次</Button>
            </div>
            <div className="drawer-content">
              工木大土工木大
            </div>
            <div className="drawer-footer">
              <Button>取消</Button>
              <Button type="primary">确定</Button>
            </div>
          </div>
        </Drawer>
      </div>
    );
  }
}

