import React, { Component } from 'react';
import { connect } from 'dva';
import {
  Form, Input, Select, Button, Radio, Steps, Checkbox, DatePicker, InputNumber, Icon, Modal, Tag, Table
} from 'antd';

import '../Task.less';

const FormItem = Form.Item;
const { Option } = Select;
const { Step } = Steps;
const { TextArea } = Input;
const { RangePicker } = DatePicker;
const { CheckableTag } = Tag;
const tagsFromServer = ['关联活动', '关联合同', '关联审批单', '关联合同（未开通）'];
const Search = { Input };
const dataSource = [{
  key: '1',
  name: '胡彦斌',
  age: 32,
  address: '西湖区湖底公园1号'
}, {
  key: '2',
  name: '胡彦祖',
  age: 42,
  address: '西湖区湖底公园1号',
}];

const columns = [{
  title: '项目名称',
  dataIndex: 'name',
  key: '1',
}, {
  title: '项目类型',
  dataIndex: 'age',
  key: '2',
}, {
  title: '项目内容',
  dataIndex: 'address',
  key: '3',
}, {
  title: '项目开始时间',
  dataIndex: 'address',
  key: '4',
}, {
  title: '项目结束时间',
  dataIndex: 'address',
  key: '5',
}];

const rowSelection = {
  onChange: (selectedRowKeys, selectedRows) => {
    console.log(`selectedRowKeys: ${selectedRowKeys}`, 'selectedRows: ', selectedRows);
  },
  getCheckboxProps: record => ({
    disabled: record.name === 'Disabled User', // Column configuration not to be checked
  }),
};

@connect(state => ({
  profile: state.profile,
}))


@Form.create()

export default class Information extends Component {
  state = {
    visible: false,
    visible1: false,
    modaltitle: '',
    selectedTags: [],
    pagenav: {
      current: 1,
      pageSize: 10,
      showQuickJumper: true,
      showSizeChanger: true,
      showTotal: total => `总共 ${total} 条`,
      onShowSizeChange: (current, pageSize) => {
        const pagenav = Object.assign({}, this.state.pagenav);
        pagenav.current = current;
        pagenav.pageSize = pageSize;
        this.setState({ pagenav });
        setTimeout(() => {
          this.bbdExampersonPage();
        });
      },
      onChange: (page, pageSize) => {
        const pagenav = Object.assign({}, this.state.pagenav);
        pagenav.current = page;
        pagenav.pageSize = pageSize;
        this.setState({ pagenav });
        setTimeout(() => {
          this.bbdExampersonPage();
        });
      },
      total: 0,
    }
  }

  componentDidMount() {
    /* const { dispatch } = this.props;
    dispatch({
      type: 'profile/fetchBasic',
    }); */
  }

  handleSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFieldsAndScroll((err, values) => {
      if (!err) {
        this.props.dispatch({
          type: 'form/submitRegularForm',
          payload: values,
        });
      }
    });
  };
  callback = (key) => {
    console.log(key);
  };

  handleChange(tag, checked) {
    const { selectedTags } = this.state;
    const nextSelectedTags = checked ?
      [...selectedTags, tag] :
      selectedTags.filter(t => t !== tag);
    console.log('You are interested in: ', nextSelectedTags);
    this.setState({ selectedTags: nextSelectedTags });
  }

  /* 验证手机号码 */
  checkPhone = (rule, value, callback) => {
    if (value && !(/^1[0-9]{10}$/).test(value)) {
      callback('请输入正确的手机号码！');
    } else {
      callback();
    }
  };


  showModal = () => {
    this.setState({
      visible: true,
    });
  }
  handleOk = (e) => {
    console.log(e);
    this.setState({
      visible: false,
    });
  }
  handleCancel = (e) => {
    console.log(e);
    this.setState({
      visible: false,
    });
  }

  render() {
    const { submitting } = this.props;
    const { getFieldDecorator } = this.props.form;
    const { selectedTags } = this.state;

    const formItemLayout = {
      labelCol: {
        xs: { span: 24 },
        sm: { span: 7 },
      },
      wrapperCol: {
        xs: { span: 24 },
        sm: { span: 12 },
        md: { span: 10 },
      },
    };

    const submitFormLayout = {
      wrapperCol: {
        xs: { span: 24, offset: 0 },
        sm: { span: 10, offset: 7 },
      },
    };

    return (
      <div className="CreateTask">
        <div className="Steps">
          <Steps current={0}>
            <Step title="基本信息" />
            <Step title="出勤配置" />
            <Step title="发布设置" />
          </Steps>
        </div>
        <Form
          onSubmit={this.handleSubmit}
          style={{ marginTop: 24 }}
        >
          <FormItem
            {...formItemLayout}
            label="任务名称"
          >
            {getFieldDecorator('company', {
              rules: [{
                required: true, message: '请输入',
              }],
            })(
              <Input placeholder="请输入" maxLength={50} />
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="所属类型"
          >
            {getFieldDecorator('address', {
              rules: [{ required: true, message: '请选择' }],
            })(
              <Select placeholder="请选择">
                <Option value="xiao">付晓晓</Option>
                <Option value="mao">周毛毛</Option>
              </Select>
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="任务类型"
          >
            {getFieldDecorator('branch', {
              rules: [{
                required: true, message: '请选择',
              }],
            })(
              <Radio.Group>
                <Radio value="1">临时</Radio>
                <Radio value="2">固定</Radio>
              </Radio.Group>
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="紧急程度"
          >
            {getFieldDecorator('branch', {
              rules: [{
                required: true, message: '请选择',
              }],
            })(
              <Radio.Group>
                <Radio value="1">普通</Radio>
                <Radio disabled value="2">紧急（未开通）</Radio>
              </Radio.Group>
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="任务类型"
          >
            {getFieldDecorator('branch', {
              rules: [{
                required: true, message: '请选择',
              }],
            })(
              <Checkbox.Group>
                <Checkbox value="1">技防</Checkbox>
                <Checkbox value="2">人防</Checkbox>
                <Checkbox value="3">随身护卫</Checkbox>
                <Checkbox value="4">安全检查</Checkbox>
                <Checkbox value="5">其他</Checkbox>
                <Checkbox disabled value="6">押运（未开通）</Checkbox>
              </Checkbox.Group>
              )}
          </FormItem>

          <FormItem
            {...formItemLayout}
            label="任务内容"
          >
            {getFieldDecorator('phonr', {
              rules: [{
                required: true, message: '请输入',
              }, {
                validator: this.checkPhone
              }],
            })(
              <TextArea autosize={{ minRows: 2, maxRows: 6 }} />
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="任务地点"
          >
            {getFieldDecorator('fax', {
              rules: [{
                required: false,
              }, {
                validator: this.checkPhone
              }],
            })(
              <Input placeholder="请输入" />
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="执行范围"
          >
            {getFieldDecorator('address', {
              rules: [{ required: true, message: '请输入' }],
            })(
              <Input addonAfter="米" />
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="关联项"
          >
            {getFieldDecorator('fax', {
              rules: [{
                required: false,
              }, {
                validator: this.checkPhone
              }],
            })(
              <div>
                <Button type="primary" onClick={this.showModal} ghost>添加关联项目</Button>
                <div className="glxm">
                  <dl>
                    <dt>关联项目：<Button onClick={() => { this.setState({ visible1: true, modaltitle: "选择项目" }); }} size="small" icon="plus">添加项目</Button></dt>
                    <dd>
                      <Icon type="paper-clip" /> <div>项目名称</div> <Icon type="close" />
                    </dd>
                    <dd>
                      <Icon type="paper-clip" /> <div>项目名称</div> <Icon type="close" />
                    </dd>
                    <dd>
                      <Icon type="paper-clip" /> <div>项目名称</div> <Icon type="close" />
                    </dd>
                  </dl>
                  <dl>
                    <dt>关联合同：<Button onClick={() => { this.setState({ visible1: true, modaltitle: "选择合同" }); }} size="small" icon="plus">添加项目</Button></dt>
                    <dd>
                      <Icon type="paper-clip" /> <div>项目名称</div> <Icon type="close" />
                    </dd>
                    <dd>
                      <Icon type="paper-clip" /> <div>项目名称</div> <Icon type="close" />
                    </dd>
                    <dd>
                      <Icon type="paper-clip" /> <div>项目名称</div> <Icon type="close" />
                    </dd>
                    <dd>
                      <Icon type="paper-clip" /> <div>项目名称</div> <Icon type="close" />
                    </dd>
                  </dl>
                </div>
              </div>
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="起止时间"
          >
            {getFieldDecorator('dateRange', {
              rules: [{ required: true, message: '请选择生效日期' }],
            })(
              <RangePicker placeholder={['开始日期', '结束日期']} style={{ width: '100%' }} />
              )}
          </FormItem>
          <FormItem
            {...formItemLayout}
            label="所需人数"
          >
            {getFieldDecorator('IndustryType', {
              rules: [{ required: true, message: '请选择行业类型' }],
            })(
              <InputNumber min={1} max={10} />
              )}

          </FormItem>
          <FormItem {...submitFormLayout} style={{ marginTop: 32 }}>
            <Button loading={submitting}>
              暂存
            </Button>
            <Button type="primary" style={{ marginLeft: 8 }} htmlType="submit">下一步</Button>
          </FormItem>
        </Form>

        <Modal
          title="选择关联项"
          cancelText="取消"
          okText="确定"
          visible={this.state.visible}
          onOk={this.handleOk}
          onCancel={this.handleCancel}
        >
          {tagsFromServer.map(tag => (
            <CheckableTag
              key={tag}
              checked={selectedTags.indexOf(tag) > -1}
              onChange={checked => this.handleChange(tag, checked)}
            >
              {tag}
            </CheckableTag>
          ))}
        </Modal>

        <Modal
          title={this.state.modaltitle}
          cancelText="取消"
          okText="确定"
          width={900}
          visible={this.state.visible1}
          closable={false}
          onOk={() => {
            this.setState({ visible1: false });
          }}
          onCancel={() => {
            this.setState({ visible1: false });
          }}
        >
          <div className="CreateTask-select-project">
            <Search
              placeholder="请输入关键词"
              onSearch={value => console.log(value)}
              style={{ width: 288, height: 32 }}
            />
            <Table rowSelection={rowSelection} pagination={this.state.pagenav} dataSource={dataSource} columns={columns} />
          </div>
        </Modal>

      </div >
    );
  }
}

