import { Modal } from 'antd';
import { bayzgzCheckResubmit } from '../../../../services/api';
import { checkPerCanSignUp } from '../../../../utils/utils';
export default function () {
  return [
    {
      title: '姓名',
      dataIndex: 'name',
      key: 'name',
    },
    {
      title: '手机号码',
      dataIndex: 'mobilePhone',
      key: 'mobilePhone',
    },
    {
      title: '身份证号',
      dataIndex: 'idCardNo',
      key: 'idCardNo',
    },
    {
      title: '部门',
      dataIndex: 'departName',
      key: 'departName',
    },
    {
      title: '认证状态',
      dataIndex: 'authStatus',
      key: 'authStatus',
      render: text => {
        let color = 'orange';
        if (text == '已认证') {
          color = 'green';
        } else if (text == '未认证') {
          color = 'red';
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '关联合同',
      dataIndex: 'htCount',
      key: 'htCount',
      render: (text, record) => {
        if (text) {
          return (
            <a
              onClick={() => {
                this.setState({
                  perId: record.perId
                });
              }}
            >
              {text}份
            </a>
          );
        }
        return (
          <span style={{ color: '#ddd' }}>未关联</span>
        );
      }
    },
    {
      title: '岗前课程学时(%)',
      dataIndex: 'learnRate',
      key: 'learnRate',
    },
    {
      title: '操作',
      dataIndex: 'operation',
      key: 'operation',
      width: 200,
      fixed: 'right',
      render: (text, record) => {
        const { perId, authStatus, htCount, learnRate } = record;
        // 已认证、有合同、学时满 才可以去报名
        if (
          authStatus == '已认证' &&
          htCount && htCount > 0 &&
          learnRate && learnRate >= 100
        ) {
          return (
            <a
              style={{ marginRight: 15 }}
              onClick={async () => {
                const { regProvince } = this.props.global.companyInfo;
                const checkPerRes = await checkPerCanSignUp(perId, regProvince);
                // 检查人员是否可以报名
                if(checkPerRes.status != '0') {
                  return Modal.warning({
                    title: checkPerRes.text
                  });
                }
                const subRes = await bayzgzCheckResubmit({ perId });
                if (subRes.retType == '0') {
                  if (subRes.data == 0) {
                    //  不可报名
                    return Modal.warning({
                      title: '不可以报名:报名已经审核通过或者审核中。'
                    });
                  } else if (subRes.data == 2) {
                    return Modal.warning({
                      title: '不可以报名:此人报名存在暂存未提交记录'
                    });
                  }
                  this.props.history.push({
                    pathname: '/PoliceDeclare/sign-up/fill-in',
                    perInfo: JSON.stringify(record),
                    bayzgzSbId: ''
                  });
                }
                // const existRes = await checkIsExistsEffectBayzgz({perId});
                // // 1:代表存在保安员资格证，不能报名，0代表不存在可以报名
                // if(existRes.data != '0') {
                //   return Modal.warning({
                //     title: '该人员已存在保安员资格证，无法报名。'
                //   });
                // }
                // // 获取人员身份验证信息
                // const authRes = await getPerAuthRecordbyId({perId});
                // const { idCardNo } = authRes.data;
                // const { companyInfo } = this.props.global;
                // const age = getAge(idCardNo);

                // // 北京、新疆、陕西、宁夏
                // if(
                //   /(^11)|(^65)|(^64)|(^61)/.test(companyInfo.regProvince) &&  //判断省份(北京、新疆、陕西、宁夏判断年龄)
                //   (age < 18 || age > 60) 
                //   ) {
                //     return Modal.warning({
                //       title: '所属地区进行保安员资格证报名人员年龄限制在18~60岁（含），该人员不在范围内。'
                //     });
                // }
                // // 广西
                // if(
                //   /^45/.test(companyInfo.regProvince) &&  //判断省份(广西判断年龄)
                //   (age < 18 || age > 65) 
                //   ) {
                //     return Modal.warning({
                //       title: '所属地区进行保安员资格证报名人员年龄限制在18~65岁（含），该人员不在范围内。'
                //     });
                // }
                // // 其他
                // if(
                //   !/(^11)|(^65)|(^64)|(^61)|(^45)/.test(companyInfo.regProvince) 
                //   && 
                //   (age < 18) 
                //   ) {
                //     return Modal.warning({
                //       title: '所属地区进行保安员资格证报名人员年龄限制在18岁（含）以上，该人员不在范围内。'
                //     });
                // }

                // if(authRes.data.authStatus != 1) {
                //   return Modal.warning({
                //     title: '该人员尚未完成实名认证，无法报名。需通过实名认证，才可进行报名。'
                //   });
                // }
                //校验该保安员资格证是否重复提交

              }}
            >
              去报名
              </a>
          );
        }
        return (
          <span style={{ color: '#ddd' }}>去报名</span>
        );
      }
    },
  ];
} 