import React, { Component } from 'react';
import { connect } from 'dva';
import { withRouter } from 'dva/router';

import PTable from '../../../../components/Pro/PTable';
import SearchForm from './SearchForm';
import ContractModal from './ContractModal';
import columnsFun from './columns';
// import st from '../../declaration.less'
import { getConfigBayzgzSb } from '../../../../services/api';
import {
  Alert,
  Modal
} from "antd";
@connect(state => ({
  global: state.global
}))
@withRouter
export default class NoCert extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false,
      pageParm: { //任务列表请求参数
        pageSize: '10',
        pageNumber: '1'
      },
      paramsInit: false, //参数是否准备好

      perId: '',  //当前人员的id
      declareNotice: ''  //指南模态框
    }
  }


  componentWillReceiveProps(props) {

  }
  componentDidMount() {
    this.__getConfigBayzgzSb();
  }
  _search = (values) => {
    this.setState({
      pageParm: {
        ...this.state.pageParm,
        ...values
      },
      paramsInit: true
    });
  }
  _updateTable = () => {
    this.setState({
      forceUpdate: true
    }, () => {
      this.setState({
        forceUpdate: false
      });
    });
  }
  //获取保安员指南
  __getConfigBayzgzSb() {
    getConfigBayzgzSb().then(
      res => {
        if (res.retType === '0') {
          this.setState({
            declareNotice: res.data.declareNotice
          })
        }
      }
    )
  }
  render() {
    const columns = columnsFun.call(this);
    return (
      <div style={{ padding: 15 }}>
        <Alert
          message={<div>
            <span>
              报名前请仔细阅读<a href="javascript: void(0)" onClick={() => {
                Modal.info({
                  className: 'anbao-modal',
                  maskClosable: true,
                  // title: '保安员资格考试报名办理指南',
                  content: (
                    <div dangerouslySetInnerHTML={{
                      __html: this.state.declareNotice
                    }} />
                  )
                });
              }}>《保安员资格考试报名办理指南》</a>，了解相关章程及规定。
            </span>
            <br />
            <span>
              本页面企业未持证人员列表，需人员满足报名条件方可进行保安资格证报名。
            </span>
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <SearchForm
          style={{ marginLeft: 10 }}
          onSearch={this._search}
        />

        {/* <section style={{ marginTop: 15 }}>
  
        </section> */}
        {
          this.state.paramsInit &&
          <PTable
            style={{ marginTop: 20 }}
            columns={columns}
            url="pageNoBayzgzPerList"
            pageParm={this.state.pageParm}
            forceUpdate={this.state.forceUpdate}
            pagination={{ showTotal: total => `总共 ${total} 条` }}
          />
        }


        <ContractModal 
          perId={this.state.perId}
          // visible={!!this.state.perId}
          onCancel={() => {this.setState({perId:''})}}
        />
      </div>
    );
  }
}
