import React, { Component } from 'react';
import st from 'styled-components';
import { connect } from 'dva';
import { withRouter } from 'dva/router';
import {
  Input,
  Button,
  Select,
  Alert,
  Modal
} from 'antd';

import tablePage from '../../../../utils/hoc/tablePage';
import { getConfigBayzgzSb } from '../../../../services/api';
import '../../declaration.less';
import columnFun from './columns';

const { Option } = Select;
@connect(state => ({
  global: state.global,
  companyInfo: state.global.companyInfo
}))
@tablePage()
@withRouter
export default class UnSubmits extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      //抽屉
      drawerVisble: false,
      isNanNiCode:false,//是否是南宁地区码
    };
  }

  componentDidMount() {
    this.__getConfigBayzgzSb()
  }

   // 判断是否是北京地区(北京地区隐藏劳动合同、户籍类型、户籍所在地三个字段)
   checkBeijinCode() {
    let regProvince = String(this.props.companyInfo.regProvince);
    return regProvince && regProvince.indexOf('110') == 0
  }
  // 判断是否为商洛地区
  checkSRAreaCode = () => {
    let regCity = String(this.props.companyInfo.regCity);
    return regCity && regCity.indexOf('611000') == 0
  }

  checkAreaCode() {
    return this.state.dataListAreaCode && (String(this.state.dataListAreaCode).indexOf('6106') == 0)
  }

  //获取保安员指南
  __getConfigBayzgzSb() {
    getConfigBayzgzSb().then(
      res => {
        if (res.retType === '0') {
          this.setState({
            declareNotice: res.data.declareNotice
          })
        }
      }
    )
  }
  // 表格渲染
  _renderList = () => {
    const columns = columnFun.call(this, this.checkAreaCode(),this.checkBeijinCode());
    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <PageTable
        style={{ marginTop: 20 }}
        columns={columns}
        url="getNoApplyBayzgzList"
        scroll={{ x: '1300px' }}
        dateChange={(data) => {
          console.log(data)
          this.setState({
            dataListAreaCode: data.other?data.other.areaCode:'',
            isNanNiCode: data.other? data.other.areaCode.toString().indexOf('4501') == 0 : false,
          })
        }}
      />
    );
  };

  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator } = this.props.form;
    return (
      <div style={{ padding: '0 24px' }}>
        <Alert
          message={<div style={{ color: '#333' }}>
            <span>只有激活状态为已激活且认证状态为已认证的才可以进行报名。如有未激活或未认证的请及时联系对应人员前往app进行激活/认证。</span><br />
            <span>报名前请仔细阅读
              <a onClick={() => {
                Modal.info({
                  className: 'anbao-modal',
                  maskClosable: true,
                  // title: '保安员资格考试报名办理指南',
                  content: (
                    <div dangerouslySetInnerHTML={{
                      __html: this.state.declareNotice
                    }} />
                  )
                });
              }}>《保安员资格考试报名办理指南》</a>，了解相关章程及规定。</span>
          </div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        {/* <SearchForm
          onSearch={this._search}
        /> */}
        <SearchForm
          arrange={values => {
            return values;
          }}
        >
          <>
            <Form.Item label="关键词">
              {getFieldDecorator('keyWord', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入姓名/手机号码/身份证" />
              )}
            </Form.Item>
            <Form.Item label="人员类别">
              {getFieldDecorator('personType', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="1">内勤人员</Option>
                  <Option value="2">普通保安员</Option>
                  <Option value="3">武装押运人员</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="激活状态">
              {getFieldDecorator('init', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未激活</Option>
                  <Option value="1">已激活</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="认证状态">
              {getFieldDecorator('identityAuthState', {
                initialValue: ''
              })(
                <Select style={{ minWidth: 150 }} >
                  <Option value="">全部</Option>
                  <Option value="0">未认证</Option>
                  <Option value="1">已认证</Option>
                </Select>
              )}
            </Form.Item>
            <Form.Item label="部门">
              {getFieldDecorator('departName', {
                initialValue: ''
              })(
                <Input style={{ width: 200 }} placeholder="请输入部门名称" />
              )}
            </Form.Item>
          </>
        </SearchForm>
        <Btns> 
          {this.checkBeijinCode()?'':
            <Button style={{ marginRight: 15}} onClick={() => {
              // this.props.history.push('/PoliceDeclare/qualifications/add');
              if (this.checkAreaCode()) {
                this.props.history.push('/PoliceDeclare/sign-up/sx-fill-in');
              } else {
                this.props.history.push({
                  pathname:'/PoliceDeclare/sign-up/fill-in',
                  isNanNiCode:this.state.isNanNiCode
                });
              }
            }} type="primary">新增报名</Button>
          }
        </Btns>
        {/* 表格 */}
        {this._renderList()}

        {/* 修改弹窗 */}
        {/* <SubDrawer
          personApplyId={this.state.personApplyId}
          onClose={() => {
            this.setState({
              personApplyId: ''
            });
          }}
        /> */}
      </div >
    );
  }
}

const Btns = st.div`
  margin-top: 15px;
  button {
    margin-right: 15px;
  }
`;