import {
  checkIsExistsEffectBayzgz,
} from '../../../../services/api';

const warnColor = '#F59A23';
const okColor = '#4B7902';
const errColor = '#D9001B';
export default function (checkAreaCodeValue,checkBeijingCodeValue) {
  return [
    {
      title: '姓名',
      dataIndex: 'realName',
      key: 'realName',
      width: 100,
      fixed: 'left',
      render: value => value || '-',
    },
    {
      title: '身份证号',
      dataIndex: 'idNumber',
      key: 'idNumber',
    },
    {
      title: '手机号码',
      dataIndex: 'phone',
      key: 'phone',
    },

    {
      title: '人员类别',
      dataIndex: 'personType',
      key: 'personType',
      render: (value) => {
        let text = '-';
        switch (true) {
          case value == '1':
            text = '内勤人员';
            break;
          case value == '2':
            text = '普通保安员';
            break;
          case value == '3':
            text = '武装押运人员';
        }
        return text;
      }
    },

    {
      title: '激活状态',
      dataIndex: 'init',
      key: 'init',
      render: (value) => {
        let text = '未激活';
        let color = '';
        switch (true) {
          case value == '0':
            text = '未激活';
            color = warnColor;
            break;
          case value == '1':
            text = '已激活';
            color = okColor;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '认证状态',
      dataIndex: 'identityAuthState',
      key: 'identityAuthState',
      render: (value) => {
        let text = '未认证';
        let color = warnColor;
        switch (true) {
          case value == '0':
            text = '未认证';
            color = warnColor;
            break;
          case value == '1':
            text = '已认证';
            color = okColor;
        }
        return (
          <span style={{ color }}>{text}</span>
        );
      }
    },
    {
      title: '部门',
      dataIndex: 'departName',
      key: 'departName',
      render: value => value || '-'
    },
    {
      title: '操作',
      dataIndex: 'operation',
      key: 'operation',
      width: 150,
      fixed: 'right',
      render: (text, record) => {
        // 北京地区暂时取消报名入口
        if(checkBeijingCodeValue){  
          return <span style={{color: '#999',display:'none'}}>报名</span>;
        }
        const {
          id, idNumber, identityAuthState
        } = record;
        if(!idNumber || identityAuthState != '1') {
          return <span style={{color: '#999'}}>报名</span>;
        }
        return (
          <div>
            <span
              style={{
                color: '#108EE9',
                cursor: 'pointer',
                marginRight: '15px',               
              }}
              onClick={() => {
                //先校验年龄限制
                checkIsExistsEffectBayzgz({perId:record.id}).then(res => {
                  let url = '/PoliceDeclare/sign-up/fill-in'
                  if(checkAreaCodeValue){
                    url= '/PoliceDeclare/sign-up/sx-fill-in'
                  }
                  this.props.history.push({
                    pathname: url,
                    bayzgzSbId: id
                  }); 
                })
              }}
            >
              报名
          </span>
          </div>
        );

      }
    }
  ];
}