import React, { PureComponent } from 'react';
import { Tabs, Modal, Alert } from 'antd';
import style from "styled-components";
import { connect } from "dva";
import NoAuthority from '../../common/NoAuthority';
import declare from '../../utils/hoc/declare';

const store = require("store");
const { TabPane } = Tabs;
@connect(state => ({
  profile: state.profile
}))
@declare
export default class DeclarationList extends PureComponent {
  constructor(props, context) {
    super(props, context);
    this.state = {
      // currentURL: "http://localhost:3000/productdetail?tit=%E4%BF%9D%E5%AE%89%E5%9F%B9%E8%AE%AD%E8%AF%BE%E7%A8%8B&systype=saas",
      // currentURL:"http://localhost:3000/#/order?trackid=2&organID=70607bb974eb44bb9847909d3461bd70",
    };
  }
  
  componentDidMount = () => {

  }
  render() {
    if (this.props.showModal) {
      return '';
    }
    return (
      <Container>
        <Tabs>
          <TabPane tab="申报列表" key="1" />
        </Tabs>
        {
          this.props.isBeijing && 
          <Alert  
            message={
              <div>
                <span>注：自行招用保安单位企业进行驻勤点备案时，请直接在【人事】-【驻勤管理】模块直接新增驻勤值守即可。</span>
              </div>
            }
            type="warning"
            showIcon
            style={{ marginBottom: '15px' }}
          />
        }
        {store.get("DeclarationListURL") !== undefined ? (
          <iframe title="申报列表" src={store.get("DeclarationListURL")["DeclarationListURL"]} width="100%" height="100%" frameBorder="0">
            您的浏览器不支持iframe，请升级
            </iframe>
        ) : (
            <NoAuthority></NoAuthority>
          )}
        {/* {store.get("saas") !== undefined ? (
          <iframe title="订单管理" src={this.state.currentURL + '&sessionId=' + store.get("saas")["sessionId"]} width="100%" height="100%" frameBorder="0">
            您的浏览器不支持iframe，请升级
            </iframe>
        ) : ''
        } */}
        {/* <iframe title="课程列表" src="http://localhost:3000/product" frameBorder="0" width="100%" height="100%">
            您的浏览器不支持iframe，请升级</iframe> */}
      </Container>
    );
  }
}

const Container = style.div`
  padding:10px 24px 24px;
  width:100%;
  height:100%;
`;
