/* 
*@props(form) 父组件的form
*@props(personType) 父组件选中的personType
*/

import React, { Component } from 'react';
import PFromUpload from '../../../../components/Pro/PFromUpload';
import { formLayout2 } from './formLayout';
import {
  Row,
  Col,
  Form
} from 'antd';

export function $getFormItems(personType) {
  const idCardNoFrontUrl = {
    label: '身份证人像面',
    fieldsName: 'idCardNoFrontUrl',
    rules: [{
      required: true,
      message: `请上传身份证人像面`
    }]
  };
  const idCardNoBackUrl = {
    label: '身份证国徽面',
    fieldsName: 'idCardNoBackUrl',
    rules: [{
      required: true,
      message: `请上传身份证国徽面`
    }]
  };
  const loseJobCertUrl = {
    label: '失业登记证',
    fieldsName: 'loseJobCertUrl',
    rules: [{
      required: true,
      message: `请上传失业登记证`
    }]
  };
  const ruralLaborTransferUrl = {
    label: '北京市农村劳动力转移就业证',
    fieldsName: 'ruralLaborTransferUrl',
    rules: [{
      required: true,
      message: `请上传北京市农村劳动力转移就业证`
    }]
  };
  const householdMainUrl = {
    label: '户口簿户主页',
    fieldsName: 'householdMainUrl',
    rules: [{
      required: true,
      message: `请上传户口簿户主页`
    }]
  };
  const householdSelfUrl = {
    label: '户口簿本人页',
    fieldsName: 'householdSelfUrl',
    rules:[ {
      required: true,
      message: `请上传户口簿本人页`
    }]
  };
  const collegeGraduateUrl = {
    label: '毕业证书',
    fieldsName: 'collegeGraduateUrl',
    rules: [{
      required: true,
      message: `请上传毕业证书`
    }]
  };
  const collegeReportUrl = {
    label: '报到证',
    fieldsName: 'collegeReportUrl',
    rules: [{
      required: true,
      message: `请上传报到证`
    }]
  };
  const retireUrl = {
    label: '退役证或退伍证',
    fieldsName: 'retireUrl',
    rules: [{
      required: true,
      message: `请上传退役证或退伍证`
    }]
  };
  const selfEmploymentUrl = {
    label: '自主就业安置证明',
    fieldsName: 'selfEmploymentUrl',
    rules: [{
      required: false,
      message: `请上传自主就业安置证明`
    }]
  };
  const returnEmployeeUrl = {
    label: '复员证',
    fieldsName: 'returnEmployeeUrl',
    rules: [{
      required: true,
      message: `请上传复员证`
    }]
  };
  const transferEmployeeUrl = {
    label: '转业证',
    fieldsName: 'transferEmployeeUrl',
    rules: [{
      required: true,
      message: `请上转业证`
    }]
  };
  const socialSecurityProveUrl = {
    label: '户籍所在区县人力社保部门开据的确认证明',
    fieldsName: 'socialSecurityProveUrl',
    rules: [{
      required: true,
      message: `请上户籍所在区县人力社保部门开据的确认证明`
    }]
  };

  let urlItems = [];
  switch(true) {
    //外省市来京务工人员(身份证人像面、身份证国徽面)
    case personType == 1:  
      urlItems = [idCardNoFrontUrl, idCardNoBackUrl];
      break;
    // 本市登记失业人员(身份证人像面、身份证国徽面、就业失业登记证)
    case personType == 2:
      urlItems = [idCardNoFrontUrl, idCardNoBackUrl, loseJobCertUrl];
      break;
    // 本市农村转移就业劳动力(身份证人像面、身份证国徽面、北京市农村劳动力转移就业证)
    case personType == 3:
      urlItems = [idCardNoFrontUrl, idCardNoBackUrl, ruralLaborTransferUrl];
      break;
    // 本市应届高校毕业生(身份证人像面、身份证国徽面、户口簿户主页、户口簿本人页、毕业证书、报到证)
    case personType == 4:
      urlItems = [idCardNoFrontUrl, idCardNoBackUrl, householdMainUrl, householdSelfUrl, collegeGraduateUrl, collegeReportUrl];
      break;
    // 本市复员专业军人-退役士兵(身份证人像面、身份证国徽面、退役证或退伍证、自主就业安置证明(选填))
    case personType == 5:
      urlItems = [idCardNoFrontUrl, idCardNoBackUrl, retireUrl, selfEmploymentUrl];
      break;
    // 本市复员专业军人-复员干部(身份证人像面、身份证国徽面、复员证、自主就业安置证明(选填))
    case personType == 6:
      urlItems = [idCardNoFrontUrl, idCardNoBackUrl, returnEmployeeUrl, selfEmploymentUrl];
      break;
    // 本市复员专业军人-专业干部(身份证人像面、身份证国徽面、转业证、户籍所在区县人力社保部门开据的确认证明。)
    case personType == 7:
      urlItems = [idCardNoFrontUrl, idCardNoBackUrl, transferEmployeeUrl, socialSecurityProveUrl];
    }
  return urlItems;
}

// @withRouter
export default class ImageFormItem extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {

    };
  }

  componentDidMount() {

  }
  render() {
    const { getFieldDecorator } = this.props.form;
    const urlItems = $getFormItems(this.props.personType);
    const rows = [];
    const length = Math.ceil(urlItems.length / 2);
    for(let i = 0; i < length; i++) {
      rows.push([
        urlItems[i * 2],
        urlItems[i * 2 + 1]
      ]);
    }
    const ItemWrap = function(props) {
      return (
        <Col span={7} offset={props.offset}>
          <Form.Item {...formLayout2} label={props.label}>
            {getFieldDecorator(props.fieldsName, {
              initialValue: props.initialValue || '',
              rules: props.rules
            })(
              <PFromUpload
                key={props.key}
                num={1}
                onChange={props.onChange}
              />
            )}
          </Form.Item>
        </Col>
      );
    }
    return (
      <>
        {
          rows.map((row, index) => {
            return (
              <Row gutter={16} key={index}>
                {
                  row.map((item, idex) => {
                    if(item) {
                      const {label, fieldsName, initialValue, rules} = item;
                      if(idex == 0) {
                        return (
                          <ItemWrap
                            offset={2}
                            label={label}
                            fieldsName={fieldsName}
                            initialValue={initialValue}
                            rules={rules}
                            key={idex}
                            onChange={() => {}}
                          />
                        );
                      }else {
                        return (
                          <ItemWrap
                            label={label}
                            fieldsName={fieldsName}
                            initialValue={initialValue}
                            rules={rules}
                            key={idex}
                            onChange={() => {}}
                          />
                        )
                      }
                    }else {
                      return '';
                    }
                  })
                }
              </Row>
            );
          })
        }
      </>
    );
  }
}

