import { Popconfirm } from "antd";
export default function() {
  return [
    {
      title: "合同名称",
      dataIndex: "contractName",
      key: "contractName",
      width: 120,
      fixed: "left",
      render: (text, record) => (
        <div
          style={{
            maxWidth: "300px",
            whiteSpace: "nowrap",
            textOverflow: "ellipsis",
            overflow: "hidden",
            marginTop: "8px",
            marginBottom: "8px"
          }}
        >
          {record.contractName}
        </div>
      )
    },
    {
      title: "合同类型",
      dataIndex: "contractType_name",
      key: "contractType_name",
      // width: 100,
      render: (text, record) => (
        <span
          style={{
            // width: '100px',
            whiteSpace: "nowrap",
            textOverflow: "ellipsis",
            overflow: "hidden"
          }}
        >
          {record.contractType_name}
        </span>
      )
    },
    {
      title: "企业档案编号",
      dataIndex: "comFileNo",
      key: "comFileNo"
    },
    {
      title: "甲方名称",
      dataIndex: "firstPartyName",
      key: "firstPartyName"
    },
    {
      title: "乙方名称",
      dataIndex: "secondPartyName",
      key: "secondPartyName"
    },
    {
      title: "丙方名称",
      dataIndex: "secondPartyName",
      key: "secondPartyName"
    },
    {
      title: "合同开始时间",
      dataIndex: "effectStartDate",
      key: "effectStartDate"
    },
    {
      title: "合同结束时间",
      dataIndex: "effectEndDate",
      key: "effectEndDate"
    },
    {
      title: "合同状态",
      dataIndex: "contractEffect",
      key: "contractEffect",
      // width: 100,
      render: (text, record) => {
        let status = "";
        switch (true) {
          case text == "未生效":
            status = "warning";
            break;
          case text == "有效":
            status = "success";
            break;
          case text == "终止":
            status = "error";
        }

        return (
          <div>
            <span>{text}</span>
          </div>
        );
      }
    },
    {
      title: "最后修改时间",
      dataIndex: "lastUpdateTime",
      key: "lastUpdateTime",
      // width: 150,
      render: (text, record) => (
        <span
          style={{
            width: "150px",
            whiteSpace: "nowrap",
            textOverflow: "ellipsis",
            overflow: "hidden"
          }}
        >
          {record.lastUpdateTime}
        </span>
      )
    },
    {
      title: "操作",
      key: "action",
      width: 120,
      fixed: "right",
      render: (text, record) => {
        // contractStatus 合同类型（1：已签订:2：已完成、9：已终止，3：已续签）
        return (
          <div>
            <Popconfirm
              overlayClassName="change-clock-pop"
              title="确定移除关联?"
              onConfirm={() => {
                this.removeContract(record);
              }}
              // onCancel={cancel}
              okText="确定"
              cancelText="取消"
            >
              <a href="javascript:void(0)" style={{ color: "red" }}>
                移除关联
              </a>
            </Popconfirm>
          </div>
        );
      }
    }
  ];
}
