import React from 'react';
import { Button, Modal, Input, Popover, Badge,Select } from 'antd';

import PTable from '../../../../components/Pro/PTable';
import $modal from "../../../../utils/modal";
import PSelect from '../../../../components/Pro/PSelect';
const Option = Select.Option;
export default class SelectContractModal extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      relationPageParm: {
        comTaskId: '',
        contractType: '',
        pageSize: '10',
        pageNumber: '1',
        keyWord: '',
        isRelationComConTract: '0',
        contractEffect: '',
      },
      keyWord: '',
      contractType: '',
      contractEffect: '',
      selectedRowKeys: [],
      selectedRows: []
    }
    this.setParentState = this.props.setParentState;
  }

  render() {
    return (
      <Modal
        width="80%"
        title="选择合同"
        visible={this.props.visible}
        okText="确定"
        cancelText="取消"
        onOk={() => {
          const { selectedRows } = this.state;
          if (selectedRows.length == 1) {
            this.props.changeSelectValue(selectedRows)
            this.props.changeVisble(false)
            // this.setParentState({
            //   comContractList: selectedRows,
            //   contractModalVisble: false
            // });
          } else {
            $modal('请选择合同。', '', null, 'error');
          }
        }}
        onCancel={() => {
          this.props.changeVisble(false)
          // this.setParentState({
          //   contractModalVisble: false
          // });
        }}
      >
        {(() => {
          const columns = [
            {
              title: '合同类型',
              dataIndex: 'contractType_name',
              key: 'contractType_name',
              // width: 100,
              render: (text, record) => (
                <span
                  style={{
                    // width: '100px',
                    whiteSpace: 'nowrap',
                    textOverflow: 'ellipsis',
                    overflow: 'hidden'
                  }}
                >
                  {record.contractType_name}
                </span>
              )
            },
            {
              title: '合同名称',
              dataIndex: 'contractName',
              key: 'contractName',
              // width: 200,
              // fixed: 'left',
              render: (text, record) => (
                <Popover
                  content={
                    <span
                      style={{
                        whiteSpace: 'normal',
                        width: '300px',
                        display: 'inline-block',
                        padding: '10px'
                      }}
                    >
                      {text}
                    </span>
                  }
                  placement="rightTop"
                >
                  <div
                    style={{
                      maxWidth: '300px',
                      whiteSpace: 'nowrap',
                      textOverflow: 'ellipsis',
                      overflow: 'hidden',
                      marginTop: '8px',
                      marginBottom: '8px'
                    }}
                  >
                    {record.contractName}
                  </div>
                </Popover>
              )
            },
            {
              title: '企业档案编号',
              dataIndex: 'comFileNo',
              key: 'comFileNo'
            },
            {
              title: '甲方名称',
              dataIndex: 'firstPartyName',
              key: 'firstPartyName'
            },
            {
              title: '乙方名称',
              dataIndex: 'secondPartyName',
              key: 'secondPartyName'
            },
            {
              title: '丙方名称',
              dataIndex: 'thirdPartyName',
              key: 'thirdPartyName'
            },
            {
              title: '合同开始时间',
              dataIndex: 'effectStartDate',
              key: 'effectStartDate'
            },
            {
              title: '合同结束时间',
              dataIndex: 'effectEndDate',
              key: 'effectEndDate'
            },
            {
              title: '合同状态',
              dataIndex: 'contractEffect',
              key: 'contractEffect',
              // width: 100,
              render: (text, record) => {
                let status = '';
                switch (true) {
                  case text == '未生效':
                    status = 'warning';
                    break;
                  case text == '有效':
                    status = 'success';
                    break;
                  case text == '终止':
                    status = 'error';
                }

                return (
                  <div>
                    <Badge status={status} />
                    <span>{text}</span>
                  </div>
                );
              }
            },
            {
              title: '最后修改时间',
              dataIndex: 'lastUpdateTime',
              key: 'lastUpdateTime',
              // width: 150,
              render: (text, record) => (
                <span
                  style={{
                    width: '150px',
                    whiteSpace: 'nowrap',
                    textOverflow: 'ellipsis',
                    overflow: 'hidden'
                  }}
                >
                  {record.lastUpdateTime}
                </span>
              )
            }
          ];
          return (
            <div>
              <label style={{ display: 'inline-block', marginRight: '16px' }}>
                关键词：
                  <Input
                  style={{
                    width: '214px',
                    marginLeft: '16px',
                    marginBottom: '16px'
                  }}
                  placeholder="合同名称/企业档案编号"
                  onChange={(e) => {
                    this.setState({
                      keyWord: e.target.value.trim()
                    });
                  }}
                  maxLength={30}
                />
              </label>
              <label>
                合同类型：
                  <PSelect
                  style={{ width: 214, marginBottom: '16px' }}
                  type="contractType"
                  onChange={(value, type) => {
                    this.setState({ [type]: value });
                  }}
                  value={this.state.contractType}
                  addOption
                  cache={false}
                />
              </label>
              <label style={{ display: 'inline-block', marginRight: '16px',marginLeft: '16px' }}>
                  合同状态：
                  <Select value={this.state.contractEffect} style={{ width: 120 }} onChange={value => {
                    this.setState({
                      contractEffect: value
                    });
                  }}>
                    <Option value="">全部</Option>
                    <Option value="0">未生效</Option>
                    <Option value="1">有效</Option>
                    <Option value="2">终止</Option>
                  </Select>
                </label>
              <Button
                id="btnSearch"
                type="primary"
                onClick={() => {
                  const relationPageParm = { ...this.state.relationPageParm };
                  const { contractType, keyWord ,contractEffect} = this.state; //合同类型//合同名称
                  relationPageParm.contractType = contractType;
                  relationPageParm.keyWord = keyWord;
                  relationPageParm.contractEffect = contractEffect;
                  this.setState(
                    {
                      relationPageParm,
                      relationForceUpdate: true
                    },
                    () => {
                      this.setState({
                        relationForceUpdate: false
                      });
                    }
                  );
                }}
                style={{ marginBottom: '16px', marginLeft: 20 }}
              >
                搜索
                </Button>
              <PTable
                style={{ marginTop: 20 }}
                columns={columns}
                url="getContractListByTask"
                pageParm={this.state.relationPageParm}
                forceUpdate={this.state.relationForceUpdate}
                rowSelection={{
                  onChange: (selectedRowKeys, selectedRows) => {
                    this.setState({
                      selectedRowKeys,
                      selectedRows,
                    });
                  },
                  type: 'radio',
                  selectedRowKeys: this.state.selectedRowKeys
                }}
              />
            </div>
          );
        })()}
      </Modal>
    );
  }
}