import React, { Component } from "react";
import st from "styled-components";
import AddPlaceModal from "./AddPlaceModal";
import PTable from '../../../../components/Pro/PTable';
import { deleteAttendAddress } from '../../../../services/api';
import { Modal, message, Alert, Button, Popconfirm } from "antd";
export default class PlaceInfo extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      addPlaceStatus: false,
      dataList: [],//考勤点数据
      selectedRowKeys: [],
      selectedRows: [],
      pageParm: { //表格参数
        pageSize: 10,
        pageNumber: 1,
        comTempTaskId: this.props.comTempTaskId,
      },
      forceUpdate: false
    };
  }

  componentDidMount() { }
  //刷新列表
  updateTable() {
    this.setState({
      forceUpdate: true
    }, () => {
      this.setState({
        forceUpdate: false
      })
    })
  }
  //删除考勤
  _deleteAttendAddress(selectedRow) {
    this.setState({
      selectedRows: [],
      selectedRowKeys: []
    })
    let data = []
    if (selectedRow.length > 0) {
      selectedRow.forEach(item => {
        data.push(item.taskAttendAddressId)
      })
    }
    deleteAttendAddress({ comTempTaskId: this.props.comTempTaskId, taskAttendAddressId: data.join(",") }).then(res => {
      if (res.retType === '0') {
        this.updateTable()
        this.props._updateTable()
      }
    })
  }

  render() {
    /* 考勤地点--drawer */
    let columns = [
      {
        key: "address",
        title: "考勤地点",
        dataIndex: "address"
      },
      {
        key: "addressRange",
        title: "考勤范围(米)",
        dataIndex: "addressRange"
      },
      {
        width: 60,
        title: "操作",
        dataIndex: "action",
        render: (text, record, index) => {
          return (
            <span>
              {
                this.props.readOnly ? <span>-</span> : <Popconfirm
                  overlayClassName="change-clock-pop"
                  title="确定删除?"
                  onConfirm={() => {
                    this._deleteAttendAddress([record]);
                  }}
                  okText="确定"
                  cancelText="取消"
                >
                  <a href="javascript:void(0)" style={{ color: "red" }}>
                    删除
                  </a>
                </Popconfirm>
              }
            </span>
          )
        }
      }
    ];
    return (
      <div>
        <Alert
          message="考勤点：任务成员可在以考勤点为圆心，有效范围为半径的地理范围内，进行App签到/签退；可添加多个考勤点；有效范围建议不要设置过小，个别人员手机设备定位不准确，会有偏差。"
          type="warning"
          showIcon
        />
        <Btns>
          <Button
            type="primary"
            onClick={() => {
              this.setState({
                addPlaceStatus: true
              })
            }}
            disabled={this.props.readOnly}
          >
            添加考勤点
          </Button>
          <Button type="danger" onClick={() => {
            const { selectedRows } = this.state;
            if (selectedRows.length == 0) {
              return Modal.warning({
                title: '温馨提示',
                content: '请先选择考勤点'
              });
            } else {
              Modal.confirm({
                title: '即将删除考勤点',
                content: '是否继续？',
                okText: '继续',
                okType: 'danger',
                cancelText: '取消',
                onOk: () => {
                  this._deleteAttendAddress(this.state.selectedRows)
                }
              });
            }
          }} disabled={this.props.readOnly}>删除</Button>
        </Btns>
        <PTable
          style={{ marginTop: 20 }}
          columns={columns}
          url="getAttendAddressList"
          pageParm={this.state.pageParm}
          pagination={false}
          forceUpdate={this.state.forceUpdate}
          rowSelection={{
            onChange: (selectedRowKeys, selectedRows) => {
              this.setState({
                selectedRowKeys,
                selectedRows,
              });
            },
            selectedRowKeys: this.state.selectedRowKeys
          }}
        />
        {
          this.state.addPlaceStatus &&
          <AddPlaceModal
            visible={this.state.addPlaceStatus}
            onChangeStatus={(value) => {
              this.setState({ addPlaceStatus: value })
            }}
            comTempTaskId={this.props.comTempTaskId}
            onHandleOk={() => {
              this.setState({
                addPlaceStatus: false,
              })
              this.updateTable()
              this.props._updateTable()
            }}
          />
        }
      </div>
    );
  }
}
const Btns = st.div`
  margin: 10px;
  >button{
    margin-left: 10px;
    &:first-child{
      margin-left: 0;
    }
  }
`;
