import React, { Component } from "react";
import {
  Alert,
  Button,
  Form,
  Modal,
  message,
  Badge,
  Tabs,
  Popover,
  notification,
  Input
} from "antd";
import PTable from "../../../../components/Pro/PTable";
import SelectContractModal from "./SelectContractModal";
import st from "styled-components";
import $nModal from "../../../../utils/modal/nModal";

@Form.create()
export default class ContractInfo extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false,
      pageParm: {
        // comTaskId: props.comTaskId || gup("id"),
        // contractType: "",
        pageSize: 10,
        pageNumber: 1
        // keyWord: "",
        // isRelationComConTract: "1" //是否关联合同（1：代表查询任务关联的合同，0：代表查询关联以外的合同）
      },
      dataList:[],//合同数据列表
      contractModalVisble: false //选择合同的模态框状态
    };
  }

  render() {
    const columns = [
      {
        title: "合同名称",
        dataIndex: "contractName",
        key: "contractName",
        // width: 200,
        // fixed: 'left',
        render: (text, record) => (
          <Popover
            content={
              <span
                style={{
                  whiteSpace: "normal",
                  width: "300px",
                  display: "inline-block",
                  padding: "10px"
                }}
              >
                {text}
              </span>
            }
            placement="rightTop"
          >
            <div
              style={{
                maxWidth: "300px",
                whiteSpace: "nowrap",
                textOverflow: "ellipsis",
                overflow: "hidden",
                marginTop: "8px",
                marginBottom: "8px"
              }}
            >
              {record.contractName}
            </div>
          </Popover>
        )
      },
      {
        title: "合同类型",
        dataIndex: "contractType_name",
        key: "contractType_name",
        // width: 100,
        render: (text, record) => (
          <span
            style={{
              // width: '100px',
              whiteSpace: "nowrap",
              textOverflow: "ellipsis",
              overflow: "hidden"
            }}
          >
            {record.contractType_name}
          </span>
        )
      },
      {
        title: "企业档案编号",
        dataIndex: "comFileNo",
        key: "comFileNo"
      },
      {
        title: "乙方名称",
        dataIndex: "secondPartyName",
        key: "secondPartyName"
      },
      {
        title: "合同有效期",
        dataIndex: "time",
        key: "time",
        render: (text, record) => {
          <span>
            {record.effectStartDate}~{record.effectEndDate}
          </span>;
        }
      },
      {
        title: "合同状态",
        dataIndex: "contractEffect",
        key: "contractEffect",
        // width: 100,
        render: (text, record) => {
          let status = "";
          switch (true) {
            case text == "未生效":
              status = "warning";
              break;
            case text == "有效":
              status = "success";
              break;
            case text == "终止":
              status = "error";
          }

          return (
            <div>
              <Badge status={status} />
              <span>{text}</span>
            </div>
          );
        }
      },
      {
        title: "操作",
        key: "action",
        // width: 200,
        render: (text, record) => {
          // contractStatus 合同类型（1：已签订:2：已完成、9：已终止，3：已续签）
          return (
            <div>
              <a
                href="javascript:void(0)"
                style={{ color: "red" }}
                onClick={() => {
                  const _this = this;
                  confirm({
                    title: "移除关联",
                    content: "确定要移除该合同",
                    okText: "确定",
                    cancelText: "取消",
                    onOk() {
                      const data = {
                        comTaskId: _this.props.comTaskId || gup("id"),
                        comContractId: record.comContractId
                      };
                      api.cancelCelateContract(data).then(res => {
                        _this.changeTable();

                        _this.props.onUpdate && _this.props.onUpdate();
                      });
                    },
                    onCancel() {
                      console.log("Cancel");
                    }
                  });
                }}
              >
                移除关联
              </a>
            </div>
          );
        }
      }
    ];
    return (
      <div>
        <Alert
          message={
            <div>
              若您需要编辑合同信息，请到
              <a href="/contractManagement/contractList">【合同管理】</a>中操作
            </div>
          }
          type="warning"
          showIcon
          style={{ marginBottom: "10px" }}
        />
        <Btns>
          <Button
            type="primary"
            onClick={() => {
              this.setState({
                contractModalVisble: true
              });
            }}
          >
            关联合同
          </Button>
        </Btns>
        <Table
          style={{ marginTop: 20 }}
          columns={columns}
          pageParm={this.state.pageParm}
          dataSource={this.state.dataList}
        />
        {/* <PTable
          style={{ marginTop: 20 }}
          columns={columns}
          url="getContractListByTask"
          pageParm={this.state.pageParm}
          //   dateChange={this.dateTableChange}
          forceUpdate={this.state.forceUpdate}
        /> */}
        {this.state.contractModalVisble && (
          <SelectContractModal
            visible={this.state.contractModalVisble}
            setParentState={this.setState.bind(this)}
          />
        )}
      </div>
    );
  }
}

const Btns = st.div`
  margin: 10px;
  >button{
    margin-left: 10px;
    &:first-child{
      margin-left: 0;
    }
  }
`;
