import React, { Component } from "react";
import {
  Button,
  Form,
  Input,
  Select,
  DatePicker
} from "antd";
// import moment from 'moment';
import PSelect from '../../../../components/Pro/PSelect';
const dateFomate = 'YYYY-MM-DD';
import {

} from '../../../../services/api';
const { Option } = Select;
const { RangePicker } = DatePicker;
@Form.create()
export default class SearchForm extends Component {
  constructor(props) {
    super(props);
    this.state = {
    }
  }
  componentDidMount() {
    this._search();
  }

  _search = (e) => {
    e && e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        // 实操培训时间
        // if(values.date.length == 0) {
        //   values.startDate = '';
        //   values.endDate = '';
        // }else {
        //   values.startDate = values.date[0].format(dateFomate);
        //   values.endDate = values.date[1].format(dateFomate);
        // }
        // Reflect.deleteProperty(values, 'date');
        this.props.onSearch(values);
      }
    });
  }
  _reset = () => {
    this.props.form.resetFields();
    this._search();
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Form layout="inline" onSubmit={this._search}>
        <Form.Item style={{ marginTop: 10 }} label="任务名称">
          {getFieldDecorator('taskName', {
            initialValue: ''
          })(
            <Input placeholder="请输入任务名称" />
          )}
        </Form.Item>
        <Form.Item style={{ marginTop: 10 }} label="任务状态">
          {getFieldDecorator('taskStatus', {
            initialValue: ''
          })(
            <PSelect
              placeholder="请选择任务状态"
              type='taskStatus'
              addOption
            />
          )}
        </Form.Item>
        <Form.Item style={{ marginTop: 10 }} label="驻勤点类型">
          {getFieldDecorator('taskStationType', {
            initialValue: ''
          })(
            <PSelect
              placeholder="请选择驻勤点类型"
              addOption
              // style={{ width: '100%' }}
              type="taskStationType" />
          )}
        </Form.Item>
        <Form.Item style={{ marginTop: 10 }} label="活动名称">
          {getFieldDecorator('activityName', {
            initialValue: ''
          })(
            <Input placeholder="请输入活动名称" />
          )}
        </Form.Item>
        {/* btns */}
        <Form.Item style={{ marginTop: 10 }} label=" " colon={false}>
          <Button type="primary" onClick={this._search}>搜索</Button>
        </Form.Item>
        <Form.Item style={{ marginTop: 10 }} label=" " colon={false}>
          <Button onClick={this._reset}>重置</Button>
        </Form.Item>
      </Form>
    );
  }
}
