import React, { Component } from "react";
import st from "styled-components";
import {
  Button,
  Alert
} from "antd";
import SearchForm from './SearchForm';
import columnsFun from './columns';
import PTable from '../../../../components/Pro/PTable';
import { getShareTempTaskList } from '../../../../services/api';
export default class CoInsurance extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false, //是否更新表格
      pageParm: { //表格参数
        pageSize: 10,
        pageNumber: 1,
      },
      searchDataReady: false, //筛选参数是否准备就绪
    };
  }
  componentDidMount() {
  }

  _search = (values) => {
    this.setState({
      pageParm: {
        ...this.state.pageParm,
        ...values
      }
    }, () => {
      if (!this.state.searchDataReady) {
        this.setState({
          searchDataReady: true
        });
      }
    });
  }
  //更新列表
  _updateTable = () => {
    this.setState({
      forceUpdate: true
    }, () => {
      this.setState({
        forceUpdate: false
      });
    });
  }
  render() {
    const columns = columnsFun.call(this);
    return (
      <div>
        <Alert
          message={<div>
            <span>我司共保的临保任务：其他承保保安服务公司共享给我司的临保任务，可进行任务信息查看，在任务中增减我司任务成员、导出排班表等操作；</span><br />
            <span style={{ color: '#F59A23' }}>注：承保公司无法管理我司人员，因此我司人员如需调整，需我司管理员及时操作，以免影响任务执勤。</span><br />
          </div>}
          type="warning"
          showIcon
        />
        <SearchForm
          onSearch={this._search}
        />
        {
          this.state.searchDataReady &&
          <PTable
            style={{ marginTop: 10 }}
            columns={columns}
            url="getShareTempTaskList"
            pageParm={this.state.pageParm}
            forceUpdate={this.state.forceUpdate}
            pagination={{
              showTotal: total => `总共 ${total} 条`
            }}
            scroll={{ x: '1500px' }}
            dateChange={() => { }}
          />
        }
      </div>
    );
  }
}

const Btns = st.div`
  margin-top: 10px;
  >button{
    margin-left: 10px;
    &:first-child{
      margin-left: 0;
    }
  }
`;

