import React, { Component } from "react";
import { connect } from "dva";
import { withRouter } from 'dva/router';
import {
  setCompanyInvoiceTaxrate,
  getCompanyVnvoiceInfo
} from '../../../services/api';
import $modal from '../../../utils/modal';
import { InvoiceTaxRate } from '../../../utils/regs';
import {
  Tabs,
  Alert,
  Input,
  Button,
  Form,
  notification 
} from "antd";
const { TabPane } = Tabs;

@Form.create()
@connect(state => ({
  profile: state.profile
}))
@withRouter
export default class Messages extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      invoiceInfo: null
    };
  }
  componentDidMount() {
    getCompanyVnvoiceInfo({}).then(res => {
      this.setState({
        invoiceInfo: res.data
      });
    });
  }
  _submitTaxRate = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if(err) return;
      setCompanyInvoiceTaxrate(values).then(res => {
        if(res.data == '0') {
          $modal(
            '企业还未设置发票信息，请访问企业信息页面进行完善',
            '',
            [{
              text: '去完善',
              type: 'primary',
              onPress: () => {
                this.props.history.push('/enterprise/company');
              }
            }]
          );
        }else {
          notification.info({
            message: res.msg
          });
        }
      }).catch(err => {
        notification.info({
          message: err.msg
        });
      });
    });
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <div style={{ paddingTop: '10px' }}>
        {
          this.state.invoiceInfo &&
          <Tabs
            tabBarStyle={{ marginLeft: 24, marginRight: 24 }}
          >
            <TabPane tab="业务开票" key="1">
              <div style={{ padding: '0 15px' }}>
                <Alert
                  message={<div>
                    配置的发票税率，将应用到业务开票模块中，系统将自动根据发票税率计算税额；已确认的业务开票记录则不会更新数据。
                  </div>}
                  type="warning"
                  showIcon
                  style={{ marginBottom: '15px' }}
                />
                <Form layout="inline" onSubmit={this._submitTaxRate}>
                  <Form.Item label="">
                    {getFieldDecorator('taxRate', {
                      initialValue: this.state.invoiceInfo.taxRate,
                      rules: [
                        {required: true, message: '请输入发票税率'},
                        {pattern: InvoiceTaxRate, message: '请输入正确的格式'},
                        {validator: (rule, val, callback) => {
                          if(val <= 0 && val!= '') {
                            callback('税率需要大于0');
                          }
                          callback();
                        }}
                      ]
                    })(
                      <Input placeholder="请填写" type="number" addonBefore="发票税率" addonAfter="%"/>
                    )}
                  </Form.Item>
                </Form>
                <Button style={{marginTop: 10}} type="primary" onClick={this._submitTaxRate}>保存</Button>
              </div>
            </TabPane>

          </Tabs>
        }
      </div>
    );
  }
}
