import React, { Component } from "react";
import { connect } from "dva";
import { withRouter } from 'dva/router';
import SearchForm from './SearchForm';
import PTable from '../../../components/Pro/PTable';
import $modal from "../../../utils/modal";
import {
  getCompanyVnvoiceInfo
} from '../../../services/api';
import {
  Tabs,
  Alert,
} from "antd";
const { TabPane } = Tabs;

@connect(state => ({
  profile: state.profile
}))
@withRouter
export default class Messages extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false,
      pageParm: {
        pageSize: '10',
        pageNumber: '1'
      },
      paramsInit: false,
      taxRate: null //是否设置了税率
    };
  }
  componentDidMount() {
    getCompanyVnvoiceInfo({}).then(res => {
      // 是否设置了税率
      const { taxRate } = res.data;
      this.setState({
        taxRate
      });
      if(!taxRate) {
        $modal(
          '您还没有设置税率',
          '请到发票设置中设置',
          [
            {
              text: '现在就去',
              type: 'primary',
              onPress: () => {
                this.props.history.replace('/invoice/setting');
              }
            }
          ]
        )
      }
    });
  }
  _search = (values) => {
    if(values.month.length > 0) {
      values.startMonth = values.month[0].format('YYYY-MM');
      values.endMonth = values.month[1].format('YYYY-MM');
    }else {
      values.startMonth = '';
      values.endMonth = '';
    }
    delete values.month;
    this.setState({
      pageParm: {
        ...this.state.pageParm,
        ...values
      },
      paramsInit: true
    });
  }
  _updateTable=() => {
    this.setState({
      forceUpdate: true
    }, () => {
      this.setState({
        forceUpdate: false
      });
    });
  }
  render() {
    const columns = [
      {
        title: '序号',
        dataIndex: 'number',
        key: 'number',
      },
      {
        title: '交易月份',
        dataIndex: 'bizMonths',
        key: 'bizMonths',
      },
      {
        title: '类型',
        dataIndex: 'bizInvoiceType',
        key: 'bizInvoiceType',
        render: text => {
          switch(text) {
            case '1':
              return <span style={{color: 'red'}}>我方应开</span>
            case '2':
              return <span style={{color: 'green'}}>我方应收</span>
          }
        }
        
      },
      {
        title: '开票方名称',
        dataIndex: 'drawer',
        key: 'drawer',
        render: text => {
          return (
            <span style={{
              maxWidth: 300,
              display: 'inline-block',
            }}>
              {text}
            </span>
          );
        }
      },
      {
        title: '开票方确认状态',
        dataIndex: 'drawerConfirm',
        key: 'drawerConfirm',
        render: text => {
          switch(text) {
            case '0':
              return <span style={{color: 'red'}}>未确认</span>
            case '1':
              return <span style={{color: 'green'}}>已确认</span>
          }
        }
      },
      {
        title: '收票方名称',
        dataIndex: 'receiver',
        key: 'receiver',
        render: text => {
          return (
            <span style={{
              maxWidth: 300,
              display: 'inline-block',
            }}>
              {text}
            </span>
          );
        }
      },
      {
        title: '收票方确认状态',
        dataIndex: 'receiverConfirm',
        key: 'receiverConfirm',
        render: text => {
          switch(text) {
            case '0':
              return <span style={{color: 'red'}}>未确认</span>
            case '1':
              return <span style={{color: 'green'}}>已确认</span>
          }
        }
      },
      {
        title: '商品名称',
        textWrap: 'ellipsis',
        dataIndex: 'product',
        key: 'product',
        render: (text, record) => {
          return (
            <span style={{
              maxWidth: 300,
              display: 'inline-block',
              // wordWrap: 'ellipsis',
              // wordBreak: 'break-all',
              // overflow: 'hidden',
              // textOverflow: 'ellipsis',
              // whiteSpace: 'nowrap',
            }}>
              {text}
            </span>
          );
        }
      },
      {
        title: '开票状态',
        dataIndex: 'makeStatus',
        key: 'makeStatus',
        render: makeStatus => {
          // 0,未开，1已开，2开票中）
          switch(makeStatus) {
            case '0':
              return <span style={{color: 'red'}}>未开票</span>;
            case '1':
              return <span style={{color: 'green'}}>已开票</span>;
            case '2':
              return <span style={{color: 'orange'}}>开票中</span>;
          }
        }
      },
      {
        title: '操作',
        dataIndex: 'operation',
        key: 'operation',
        render: (text, record) => (
          <span
            style={{
              color: '#108EE9',
              cursor: 'pointer',
              marginRight: '20px'
            }}
            onClick={() => {
              this.props.history.push(`/invoice/detail?comBizInvoiceId=${record.comBizInvoiceId}`);
            }}
          >
            开票明细
          </span>
        )
      }
    ];
    return (
      <div style={{ paddingTop: '10px' }}>
        {
          this.state.taxRate && 
        <Tabs
          tabBarStyle={{ marginLeft: 24, marginRight: 24 }}
        >
          <TabPane tab="业务开票" key="1">
            <div style={{ padding: '0 15px' }}>
              <Alert
                message={<div>
                  <span>开票明细：每月1号系统自动汇总上月的交易数据，您可查看开票明细进行数据对账；</span><br />
                  {/* <span>
开电子发票：若您已开通在线开电子发票服务，且发票双方已确认开票数据，则可直接开通电子发票。如何在线开电子发票？</span><br /> */}
                </div>}
                type="warning"
                showIcon
                style={{ marginBottom: '15px' }}
              />
              <SearchForm
                style={{marginLeft: 10}}
                onSearch={this._search}
              />

              {
                this.state.paramsInit && 
                <PTable
                  style={{ marginTop: 20 }}
                  columns={columns}
                  url="companyBizInvoiceList"
                  pageParm={this.state.pageParm}
                  forceUpdate={this.state.forceUpdate}
                  pagination={{ showTotal: total => `总共 ${total} 条` }}
                />
              }

            </div>
          </TabPane>

        </Tabs>
        }
      </div>
    );
  }
}
