import React, { Component } from "react";
import SearchForm from './SearchForm';
import PTable from '../../../components/Pro/PTable';
import {
  Tabs
} from "antd";
import {
  bktGetInvoiceTotal,
} from '../../../services/api';
const { TabPane } = Tabs;

export default class Messages extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false, //是否更新表格
      pageParm: { //表格参数
        pageSize: '10',
        pageNumber: '1',
        comBizInvoiceId: '', //父组件传入的id
      },
      searchDataReady: false, //筛选参数是否准备就绪
      comBizInvoiceIdReady: false, //comBizInvoiceId是否准备就绪
      statisticsInfo: null, //表格上面部分统计数据
    };
  }
  componentDidMount() {
    
  }
  componentWillReceiveProps(nextProps) {
    const { comBizInvoiceId } = nextProps;
    if(comBizInvoiceId && comBizInvoiceId != this.state.comBizInvoiceId) {
      this.setState({
        pageParm: {
          ...this.state.pageParm,
          comBizInvoiceId
        },
        comBizInvoiceIdReady: true
      }, () => {
        // 获取统计数据
        if(!this.state.statisticsInfo) {
          this.setState({
            statisticsInfo: {}
          }, () => {
            bktGetInvoiceTotal({comBizInvoiceId}).then(res => {
              this.setState({
                statisticsInfo: res.data
              });
            });
          });
        }
      });
    }
  }
  _search = (values) => {
    this.setState({
      pageParm: {
        ...this.state.pageParm,
        ...values
      },
      searchDataReady: true
    });
  }
  render() {
    const columns = [
      {
        title: '序号',
        dataIndex: 'number',
        key: 'number',
      },
      {
        title: '类型',
        dataIndex: 'bizType',
        key: 'bizType',
      },
      {
        title: '课程名称',
        dataIndex: 'trackName',
        key: 'trackName',
      },
      {
        title: '学员名称',
        dataIndex: 'fullName',
        key: 'fullName',
      },
      // {
      //   title: '开票方确认状态',
      //   dataIndex: 'drawerConfirm',
      //   key: 'drawerConfirm',
      // },
      {
        title: '身份证号',
        dataIndex: 'identityNumber',
        key: 'identityNumber',
      },
      {
        title: '手机号码',
        dataIndex: 'phone',
        key: 'phone',
      },
      {
        title: '付款方名称',
        dataIndex: 'drawerName',
        key: 'drawerName',
      },
      {
        title: '收款方名称',
        dataIndex: 'receverName',
        key: 'receverName',
      },
      {
        title: '金额(元)',
        dataIndex: 'amount',
        key: 'amount',
        render: (text) => {
          return Number(text).toFixed(2);
        }
      },
      {
        title: '交易时间',
        dataIndex: 'bizDate',
        key: 'bizDate',
      },
      {
        title: '对应业务订单号',
        dataIndex: 'bizOrderNo',
        key: 'bizOrderNo',
      }
    ];
    const { statisticsInfo } = this.state;
    return (
      <div>
        <Tabs>
          <TabPane tab="培训业务数据" key="1">
            {
              statisticsInfo && 
              <div style={{marginBottom: 15}}>
                新购总人数：<span style={{color: '#02A7F0'}}>{statisticsInfo.orderCount}</span> &nbsp;&nbsp;
                |&nbsp;&nbsp;
                退款总人数：<span style={{color: '#02A7F0'}}>{statisticsInfo.refundCount}</span>&nbsp;&nbsp;
                |&nbsp;&nbsp;
                净增人数：{statisticsInfo.netCount} &nbsp;&nbsp;
                | &nbsp;&nbsp;
                总收入(元)：<span style={{color: '#F59A23'}}>{Number(statisticsInfo.orderAmount).toFixed(2)}</span> &nbsp;&nbsp;
                | &nbsp;&nbsp;
                总支出(元)：<span style={{color: '#F59A23'}}>{Number(statisticsInfo.refundAmount).toFixed(2)}</span> &nbsp;&nbsp;
                | &nbsp;&nbsp;
                净收入(元)：<span style={{color: '#F59A23'}}>{Number(statisticsInfo.netAmount).toFixed(2)}</span> &nbsp;&nbsp;
              </div>
            }
            <SearchForm
              style={{ marginLeft: 10 }}
              onSearch={this._search}
              comBizInvoiceId={this.state.pageParm.comBizInvoiceId}
            />

            {
              this.state.searchDataReady && this.state.comBizInvoiceIdReady &&
              <PTable
                style={{ marginTop: 20 }}
                columns={columns}
                url="bktPageInvoiceLine"
                pageParm={this.state.pageParm}
                forceUpdate={this.state.forceUpdate}
                pagination={{ showTotal: total => `总共 ${total} 条` }}
              />
            }
          </TabPane>

        </Tabs>
      </div>
    );
  }
}
