import React, { Component } from "react";
import {
  Button,
  Form,
  Input
} from "antd";
import {
  host,
  getExportBizInvoiceInfo
} from '../../../services/api';
@Form.create()
export default class Messages extends Component {
  componentDidMount() {
    this.props.onSearch(this.props.form.getFieldsValue());
  }
  _search = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (!err) {
        // 搜索的时候重置为第一页
        values.pageNumber = 1;
        this.props.onSearch(values);
      }
    });
  }
  _reset = () => {
    this.props.form.resetFields();
    this.setState({
      month: []
    });
    const data = this.props.form.getFieldsValue();
    data.month = [];
    this.props.onSearch(data);
}
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Form layout="inline" onSubmit={this._search}>
        <Form.Item label="学员信息">
          {getFieldDecorator('keyword', {
            initialValue: ''
          })(
            <Input placeholder="学员名称/身份证号/手机号码" />
          )}
        </Form.Item>
        {/* <Form.Item label="付款方名称">
          {getFieldDecorator('drawerName', {
            initialValue: ''
          })(
            <Input placeholder="请输入付款方名称" />
          )}
        </Form.Item>
        <Form.Item label="收款方名称">
          {getFieldDecorator('receiverName', {
            initialValue: ''
          })(
            <Input placeholder="请输入收款方名称" />
          )}
        </Form.Item> */}
        <Form.Item label=" " colon={false}>
          <Button type="primary" onClick={this._search}>搜索</Button>
        </Form.Item>
        <Form.Item label=" " colon={false}>
          <Button onClick={this._reset}>重置</Button>
        </Form.Item>
        <Form.Item label=" " colon={false}>  
          <Button type="primary"
              onClick={() => {
                const { comBizInvoiceId } = this.props;
                window.open(`${host}/enterprise/company/com-biz-invoice/export/bkt/page-invoice-line?comBizInvoiceId=${comBizInvoiceId}`);
                // getExportBizInvoiceInfo({comBizInvoiceId}).then(res => {
                //   // const { drawerComId, receiverComId, productId, startDate, endDate } = res.data;
                //   const info = res.data;
                //   var paramString = Object.keys(info).reduce((a, b) => {
                //     return `${a}${b}=${info[b]}&`
                //   }, '').slice(0, -1);
                //   window.open(`${host}/enterprise/company/com-biz-invoice/export/bkt/page-invoice-line?${paramString}`);
                // });
              }}
            >导出</Button>
        </Form.Item>
      </Form>
    );
  }
}
